/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.spell;

import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.sandius.rembulan.LuaRuntimeException;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.IllegalOperationAttemptException;
import net.sandius.rembulan.runtime.LuaFunction;
import net.sandius.rembulan.runtime.UnresolvedControlThrowable;
import net.wizardsoflua.event.CustomEvent;
import net.wizardsoflua.event.EventHandlerType;
import net.wizardsoflua.event.WolEvent;
import net.wizardsoflua.lua.Converters;
import net.wizardsoflua.lua.module.event.EventInterceptor;
import net.wizardsoflua.lua.module.event.EventQueue;
import net.wizardsoflua.lua.scheduling.LuaScheduler;
import net.wizardsoflua.spell.SpellAuraFX;
import net.wizardsoflua.spell.SpellProgram;
import net.wizardsoflua.spell.SpellScope;
import net.wizardsoflua.spell.SpellServerCommandSource;
import net.wizardsoflua.spell.VirtualEntity;
import org.jetbrains.annotations.Nullable;

public class Spell
extends VirtualEntity {
    public static final String NAME = "Spell";
    private final long sid;
    private final SpellScope spellScope;
    private final SpellProgram program;
    private boolean visible = false;
    private final Multimap<String, EventQueue> queues = HashMultimap.create();
    private final EventQueue.Context eventQueueContext = new EventQueue.Context(){

        @Override
        public void stop(EventQueue queue) {
            for (String name : queue.getNames()) {
                Spell.this.queues.remove((Object)name, (Object)queue);
            }
        }

        @Override
        public long getCurrentTime() {
            return Spell.this.spellScope.getWorld().method_8510();
        }

        @Override
        public void pauseIfRequested(ExecutionContext context) throws IllegalOperationAttemptException, LuaRuntimeException, UnresolvedControlThrowable {
            Spell.this.program.getScheduler().pauseIfRequested(context);
        }
    };
    private final Multimap<String, EventInterceptor> interceptors = Multimaps.newListMultimap(new LinkedHashMap(), (Supplier)new Supplier<List<EventInterceptor>>(this){

        public List<EventInterceptor> get() {
            return new CopyOnWriteArrayList<EventInterceptor>();
        }
    });
    private final EventInterceptor.Context interceptorContext = new EventInterceptor.Context(){

        @Override
        public void stop(EventInterceptor interceptor) {
            for (String eventName : interceptor.getNames()) {
                Spell.this.interceptors.remove((Object)eventName, (Object)interceptor);
            }
        }

        @Override
        public void handleException(String contextMessage, Throwable t) {
            Spell.this.program.handleException(contextMessage, t);
        }

        @Override
        public LuaScheduler getScheduler() {
            return Spell.this.program.getScheduler();
        }

        @Override
        public Converters getConverters() {
            return Spell.this.spellScope.getConverters();
        }
    };

    public Spell(long sid, SpellScope spellScope, class_243 pos, SpellProgram program) {
        super(spellScope, pos);
        this.sid = sid;
        this.spellScope = Objects.requireNonNull(spellScope, "spellScope");
        this.program = Objects.requireNonNull(program, "program");
        String name = "Spell-" + sid;
        this.setName(name);
        program.getScheduler().addPauseContext(this::shouldPause);
        program.setSpell(this);
        spellScope.setSpell(this);
    }

    public boolean shouldPause() {
        if (this.queues.isEmpty()) {
            return false;
        }
        long now = this.spellScope.getWorld().method_8510();
        for (EventQueue queue : this.queues.values()) {
            long waitUntil = queue.getWaitUntil();
            if (now >= waitUntil) continue;
            return queue.isEmpty();
        }
        return false;
    }

    public long getSid() {
        return this.sid;
    }

    public SpellProgram getProgram() {
        return this.program;
    }

    @Nullable
    public class_1297 getOwner() {
        return this.spellScope.getOwner();
    }

    public SpellScope getSpellScope() {
        return this.spellScope;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void tick() {
        if (this.program.isFinished()) {
            return;
        }
        super.tick();
        this.program.resume();
        if (this.program.isFinished()) {
            this.setDead();
            return;
        }
        if (this.visible) {
            SpellAuraFX.spawnParticle(this);
        }
    }

    @Override
    public void setDead() {
        if (!this.program.isFinished()) {
            this.program.finish();
        }
        if (!this.program.isTerminated()) {
            super.setDead();
            this.program.terminate();
        }
    }

    public boolean onEvent(String eventName, WolEvent event, EventHandlerType eventHandlerType) {
        if (this.spellScope.getConverters().isSupported(event.getClass())) {
            Object luaEvent = this.spellScope.getConverters().toLua(event);
            if (eventHandlerType == EventHandlerType.BOTH || eventHandlerType == EventHandlerType.INTERCEPTORS) {
                for (EventInterceptor eventInterceptor : this.interceptors.get((Object)eventName)) {
                    Boolean proceed = eventInterceptor.onEvent(luaEvent);
                    if (event.shouldAbort()) {
                        return false;
                    }
                    if (proceed == null || proceed.booleanValue() || !event.canBeCanceled()) continue;
                    return false;
                }
            }
            if (eventHandlerType == EventHandlerType.BOTH || eventHandlerType == EventHandlerType.COLLECTORS) {
                event.onBeforeCollect();
                for (EventQueue eventQueue : this.queues.get((Object)eventName)) {
                    eventQueue.add(event);
                }
            }
        }
        return true;
    }

    public boolean fireEvent(CustomEvent customEvent) {
        return this.spellScope.getSpellRegistry().forwardEvent(customEvent.name(), customEvent, EventHandlerType.BOTH);
    }

    public EventQueue createEventQueue(List<String> eventNames) {
        EventQueue result = new EventQueue(eventNames, this.eventQueueContext);
        for (String name : eventNames) {
            this.queues.put((Object)name, (Object)result);
        }
        return result;
    }

    public EventInterceptor createEventInterceptor(List<String> eventNames, LuaFunction eventHandler, @Nullable Long luaTicksLimit) {
        luaTicksLimit = luaTicksLimit == null ? this.program.getLuaTicksLimit() : luaTicksLimit.longValue();
        EventInterceptor result = new EventInterceptor(eventNames, eventHandler, luaTicksLimit, this.interceptorContext);
        for (String name : eventNames) {
            this.interceptors.put((Object)name, (Object)result);
        }
        return result;
    }

    public int execute(String cmdStr, class_2165 commandOutput) {
        cmdStr = cmdStr.startsWith("/") ? cmdStr.substring(1) : cmdStr;
        SpellServerCommandSource commandSource = this.createCommandSource(commandOutput);
        CommandDispatcher commandDispatcher = this.getWorld().method_8503().method_3734().method_9235();
        try {
            int result = commandDispatcher.execute(cmdStr, (Object)commandSource);
            return result;
        }
        catch (CommandSyntaxException e) {
            commandSource.method_9213(Spell.getErrorMessage(e));
            return 0;
        }
    }

    private static class_2561 getErrorMessage(CommandSyntaxException e) {
        class_2561 message = class_2564.method_10883((Message)e.getRawMessage());
        String context = e.getContext();
        return context != null ? class_2561.method_43469((String)"command.context.parse_error", (Object[])new Object[]{message, e.getCursor(), context}) : message;
    }

    @Override
    public SpellServerCommandSource createCommandSource(class_2165 output) {
        return super.createCommandSource(output).setSpell(this);
    }

    public Iterable<Spell> findSpells(List<Predicate<Spell>> predicates) {
        return this.spellScope.getSpellRegistry().filter(predicates);
    }

    public class_2680 getBlockState() {
        return this.spellScope.getWorld().method_8320(this.getBlockPos());
    }

    public class_2586 getBlockEntity() {
        class_2586 result = this.spellScope.getWorld().method_8321(this.getBlockPos());
        return result;
    }

    public void setBlockState(class_2680 blockState) {
        this.getWorld().method_8501(this.getBlockPos(), blockState);
    }
}

