package net.wizardsoflua.chunk;

import static com.google.common.base.Preconditions.checkNotNull;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_3218;

public class Ticket {

  private final class_3218 world;
  private final Set<ChunkForce> chunkForces = new HashSet<>();

  public Ticket(class_3218 world) {
    this.world = checkNotNull(world, "world == null!");
  }

  public class_3218 getWorld() {
    return world;
  }

  void add(ChunkForce chunkForce) {
    chunkForces.add(chunkForce);
  }

  void remove(ChunkForce chunkForce) {
    chunkForces.remove(chunkForce);
  }

  public void release() {
    for (ChunkForce chunkForce : chunkForces) {
      chunkForce.remove(this);
    }
    chunkForces.clear();
  }

}
