package net.wizardsoflua.command.dynamic;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public record ParseResult(List<Token> tokens) {
  public String getNodeId() {
    return getNodeId(tokens.size() - 1);
  }

  public String getNodeId(int index) {
    return tokens.subList(0, index + 1).stream().map(it -> it.node())
        .collect(Collectors.joining("."));
  }

  public int findLastPlaceholderIndex() {
    int last = -1;
    for (int i = 0; i < tokens.size(); i++) {
      if (tokens.get(i).isPlaceholder())
        last = i;
    }
    return last;
  }

  public Collection<String> getNodeIds() {
    return IntStream.range(0, tokens.size()).mapToObj(i -> getNodeId(i)).toList();
  }
}
