package net.wizardsoflua.lua.classes;

import static java.util.Objects.requireNonNull;
import org.jetbrains.annotations.Nullable;
import com.google.common.reflect.TypeToken;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.IllegalOperationAttemptException;
import net.wizardsoflua.extension.spell.api.resource.LuaConverters;
import net.wizardsoflua.filesystem.WolServerFileSystem;
import net.wizardsoflua.lua.module.types.Types;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.lua.table.PropertyTable;
import net.wizardsoflua.spell.SpellScope;
import net.wizardsoflua.world.WorldChunkTracker;

public abstract class AbstractLuaClass<J, L extends AbstractLuaInstance<J, ?>>
    extends PropertyTable {
  @SuppressWarnings({"serial"})
  private final TypeToken<J> typeTokenJ = new TypeToken<J>(getClass()) {};
  @SuppressWarnings("unchecked")
  private final Class<J> classJ = (Class<J>) typeTokenJ.getRawType();

  @SuppressWarnings({"serial"})
  private final TypeToken<L> typeTokenL = new TypeToken<L>(getClass()) {};
  @SuppressWarnings("unchecked")
  private final Class<L> classL = (Class<L>) typeTokenL.getRawType();

  private final String name;
  private final @Nullable AbstractLuaClass<? super J, ?> luaSuperclass;
  private final SpellScope spellScope;

  public AbstractLuaClass(String name, SpellScope spellScope,
      @Nullable AbstractLuaClass<? super J, ?> luaSuperclass) {
    super(true);
    this.name = requireNonNull(name, "name");
    this.spellScope = requireNonNull(spellScope, "spellScope");;
    this.luaSuperclass = luaSuperclass;
    if (luaSuperclass != null) {
      super.setMetatable(luaSuperclass);
    }
    rawset("__index", this);
  }

  protected LuaInstanceCache getInstanceCache() {
    return spellScope.getInstanceCache();
  }

  @Override
  public Table setMetatable(Table mt) {
    throw new IllegalOperationAttemptException(
        "illegal attempt to modify metatable for lua class " + this);
  }

  public AbstractLuaClass<? super J, ?> getLuaSuperclass() {
    return luaSuperclass;
  }

  public WorldChunkTracker getWorldChunkTracker() {
    return spellScope.getWorldChunkTracker();
  }

  public class_3218 getWorld() {
    return spellScope.getWorld();
  }

  public class_2168 getCommandSource() {
    return spellScope.getCommandSource();
  }

  public LuaConverters getConverters() {
    return spellScope.getConverters();
  }

  public Types getTypes() {
    return spellScope.getTypes();
  }

  public NbtConverter getNbtConverter() {
    return spellScope.getNbtConverter();
  }

  public WolServerFileSystem getWolServerFileSystem() {
    return spellScope.getWolServerFileSystem();
  }

  public String getName() {
    return name;
  }

  public Class<J> getJavaClass() {
    return classJ;
  }

  public Class<L> getLuaInstanceClass() {
    return classL;
  }

  public @Nullable J toJava(L luaInstance) {
    return luaInstance.getDelegate();
  }

  public Object toLua(J javaInstance) {
    return getInstanceCache().getOrCreate(javaInstance, this::createNewLuaInstance);
  }

  protected abstract L createNewLuaInstance(J javaInstance);
}
