package net.wizardsoflua.lua.classes;

import net.minecraft.class_3218;
import net.wizardsoflua.event.AfterPlayerBlockBreakEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaAfterPlayerBlockBreakEvent< //
    J extends AfterPlayerBlockBreakEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<AfterPlayerBlockBreakEvent, LuaAfterPlayerBlockBreakEvent<AfterPlayerBlockBreakEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("AfterPlayerBlockBreakEvent", spellScope, null);
    }

    @Override
    protected final LuaAfterPlayerBlockBreakEvent<AfterPlayerBlockBreakEvent, Class> createNewLuaInstance(
        AfterPlayerBlockBreakEvent javaInstance) {
      return new LuaAfterPlayerBlockBreakEvent<>(this, javaInstance);
    }
  }

  public LuaAfterPlayerBlockBreakEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("world", this::getWorld);
    addReadOnly("player", this::getPlayer);
    addReadOnly("pos", this::getPos);
    addReadOnly("block", this::getBlock);
    addReadOnly("blockEntity", this::getBlockEntity);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getWorld() {
    class_3218 world = getDelegate().world();
    return getConverters().toLua(world);
  }

  private Object getPlayer() {
    return getConverters().toLua(getDelegate().player());
  }

  private Object getPos() {
    return getConverters().toLua(getDelegate().pos());
  }

  private Object getBlock() {
    return getConverters().toLua(getDelegate().blockState());
  }

  private Object getBlockEntity() {
    return getConverters().toLuaNullable(getDelegate().blockEntity());
  }
}
