package net.wizardsoflua.lua.classes;

import net.minecraft.class_3222;
import net.wizardsoflua.event.AfterPlayerRespawnEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaAfterPlayerRespawnEvent< //
    J extends AfterPlayerRespawnEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<AfterPlayerRespawnEvent, LuaAfterPlayerRespawnEvent<AfterPlayerRespawnEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("AfterPlayerRespawnEvent", spellScope, null);
    }

    @Override
    protected final LuaAfterPlayerRespawnEvent<AfterPlayerRespawnEvent, Class> createNewLuaInstance(
        AfterPlayerRespawnEvent javaInstance) {
      return new LuaAfterPlayerRespawnEvent<>(this, javaInstance);
    }
  }

  public LuaAfterPlayerRespawnEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("oldPlayer", this::getOldPlayer);
    addReadOnly("newPlayer", this::getNewPlayer);
    addReadOnly("alive", this::isAlive);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getOldPlayer() {
    class_3222 result = getDelegate().oldPlayer();
    return getConverters().toLua(result);
  }

  private Object getNewPlayer() {
    class_3222 result = getDelegate().newPlayer();
    return getConverters().toLua(result);
  }

  private Object isAlive() {
    boolean result = getDelegate().alive();
    return getConverters().toLua(result);
  }
}
