package net.wizardsoflua.lua.classes;

import net.minecraft.class_1937;
import net.wizardsoflua.event.BeforePlayerBlockBreakEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaBeforePlayerBlockBreakEvent< //
    J extends BeforePlayerBlockBreakEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<BeforePlayerBlockBreakEvent, LuaBeforePlayerBlockBreakEvent<BeforePlayerBlockBreakEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("BeforePlayerBlockBreakEvent", spellScope, null);
    }

    @Override
    protected final LuaBeforePlayerBlockBreakEvent<BeforePlayerBlockBreakEvent, Class> createNewLuaInstance(
        BeforePlayerBlockBreakEvent javaInstance) {
      return new LuaBeforePlayerBlockBreakEvent<>(this, javaInstance);
    }
  }

  public LuaBeforePlayerBlockBreakEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("world", this::getWorld);
    addReadOnly("player", this::getPlayer);
    addReadOnly("pos", this::getPos);
    addReadOnly("block", this::getBlock);
    addReadOnly("blockEntity", this::getBlockEntity);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getWorld() {
    class_1937 world = getDelegate().world();
    return getConverters().toLua(world);
  }

  private Object getPlayer() {
    return getConverters().toLua(getDelegate().player());
  }

  private Object getPos() {
    return getConverters().toLua(getDelegate().pos());
  }

  private Object getBlock() {
    return getConverters().toLua(getDelegate().blockState());
  }

  private Object getBlockEntity() {
    return getConverters().toLuaNullable(getDelegate().blockEntity());
  }
}
