package net.wizardsoflua.lua.classes;

import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1799;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.function.NamedFunction3;
import net.wizardsoflua.spell.SpellScope;

public class LuaLivingEntity< //
    J extends class_1309, //
    LC extends AbstractLuaClass<?, ?> //
> extends LuaEntity<J, LC> {

  public static class Class
      extends AbstractLuaClass<class_1309, LuaLivingEntity<class_1309, LuaLivingEntity.Class>> {
    public Class(SpellScope spellScope, LuaEntity.Class luaSuperclass) {
      super("LivingEntity", spellScope, luaSuperclass);
      addFunction(new GetItemInHand());
      addFunction(new SetItemInHand());
      addFunction(new SetEquipment());
      addFunction(new GetEquipment());
    }

    @Override
    protected LuaLivingEntity<class_1309, LuaLivingEntity.Class> createNewLuaInstance(
        class_1309 javaInstance) {
      return new LuaLivingEntity<>(this, javaInstance);
    }

    class GetItemInHand extends NamedFunction2 {
      @Override
      public String getName() {
        return "getItemInHand";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaLivingEntity<?, ?> self =
            getConverters().toJava(LuaLivingEntity.class, arg1, 1, "self", getName());
        class_1268 hand = getConverters().toJava(class_1268.class, arg2, 2, "hand", getName());
        class_1309 entity = self.getDelegate();
        class_1799 result = entity.method_5998(hand);
        if (result == class_1799.field_8037) {
          result = null;
        }
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(result));
      }
    }

    class SetItemInHand extends NamedFunction3 {
      @Override
      public String getName() {
        return "setItemInHand";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        LuaLivingEntity<?, ?> self =
            getConverters().toJava(LuaLivingEntity.class, arg1, 1, "self", getName());
        class_1268 hand = getConverters().toJava(class_1268.class, arg2, 2, "hand", getName());
        class_1799 stack =
            getConverters().toJavaNullable(class_1799.class, arg3, 3, "item", getName());
        if (stack == null) {
          stack = class_1799.field_8037;
        }
        class_1309 entity = self.getDelegate();
        entity.method_6122(hand, stack);
        context.getReturnBuffer().setTo();
      }
    }

    class SetEquipment extends NamedFunction3 {
      @Override
      public String getName() {
        return "setEquipment";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        LuaLivingEntity<?, ?> self =
            getConverters().toJava(LuaLivingEntity.class, arg1, 1, "self", getName());
        class_1304 slot =
            getConverters().toJava(class_1304.class, arg2, 2, "slot", getName());
        class_1799 stack =
            getConverters().toJavaNullable(class_1799.class, arg3, 3, "item", getName());
        if (stack == null) {
          stack = class_1799.field_8037;
        }
        class_1309 entity = self.getDelegate();
        entity.method_5673(slot, stack);
        context.getReturnBuffer().setTo();
      }
    }

    class GetEquipment extends NamedFunction2 {
      @Override
      public String getName() {
        return "getEquipment";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaLivingEntity<?, ?> self =
            getConverters().toJava(LuaLivingEntity.class, arg1, 1, "self", getName());
        class_1304 slot =
            getConverters().toJava(class_1304.class, arg2, 2, "slot", getName());
        class_1309 entity = self.getDelegate();
        class_1799 result = entity.method_6118(slot);
        if (result == class_1799.field_8037) {
          result = null;
        }
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(result));
      }
    }
  }

  public LuaLivingEntity(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance);
    add("health", this::getHealth, this::setHealth);
    addReadOnly("baby", this::isBaby);
    addReadOnly("hostile", this::isHostile);
  }

  private Object getHealth() {
    return getConverters().toLua(getDelegate().method_6032());
  }

  private void setHealth(Object luaObject) {
    float health = getConverters().toJava(float.class, luaObject, "health");
    getDelegate().method_6033(health);
  }

  private Object isBaby() {
    return getConverters().toLua(getDelegate().method_6109());
  }

  private Object isHostile() {
    return getConverters().toLua(getDelegate() instanceof class_1588);
  }
}
