package net.wizardsoflua.lua.classes;

import net.wizardsoflua.event.PlayerDropSelectedItemEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerDropSelectedItemEvent< //
    J extends PlayerDropSelectedItemEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<PlayerDropSelectedItemEvent, LuaPlayerDropSelectedItemEvent<PlayerDropSelectedItemEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerDropSelectedItem", spellScope, null);
    }

    @Override
    protected final LuaPlayerDropSelectedItemEvent<PlayerDropSelectedItemEvent, Class> createNewLuaInstance(
        PlayerDropSelectedItemEvent javaInstance) {
      return new LuaPlayerDropSelectedItemEvent<>(this, javaInstance);
    }
  }

  public LuaPlayerDropSelectedItemEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("player", this::getPlayer);
    addReadOnly("item", this::getItem);
    addReadOnly("entireStack", this::getEntireStack);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getPlayer() {
    return getConverters().toLua(getDelegate().player());
  }

  private Object getItem() {
    return getConverters().toLua(getDelegate().itemStack());
  }

  private Object getEntireStack() {
    return getConverters().toLua(getDelegate().entireStack());
  }
}
