package net.wizardsoflua.lua.classes;

import net.minecraft.class_1268;
import net.minecraft.class_3222;
import net.wizardsoflua.event.PlayerHandSwingEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerHandSwingEvent< //
    J extends PlayerHandSwingEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<PlayerHandSwingEvent, LuaPlayerHandSwingEvent<PlayerHandSwingEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerHandSwingEvent", spellScope, null);
    }

    @Override
    protected final LuaPlayerHandSwingEvent<PlayerHandSwingEvent, Class> createNewLuaInstance(
        PlayerHandSwingEvent javaInstance) {
      return new LuaPlayerHandSwingEvent<>(this, javaInstance);
    }
  }

  public LuaPlayerHandSwingEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("player", this::getPlayer);
    addReadOnly("hand", this::getHand);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getPlayer() {
    class_3222 result = getDelegate().player();
    return getConverters().toLua(result);
  }

  private Object getHand() {
    class_1268 result = getDelegate().hand();
    return getConverters().toLua(result);
  }
}
