package net.wizardsoflua.lua.classes;

import net.minecraft.class_3222;
import net.wizardsoflua.event.PlayerJoinedEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerJoinedEvent< //
    J extends PlayerJoinedEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<PlayerJoinedEvent, LuaPlayerJoinedEvent<PlayerJoinedEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerJoinedEvent", spellScope, null);
    }

    @Override
    protected final LuaPlayerJoinedEvent<PlayerJoinedEvent, Class> createNewLuaInstance(
        PlayerJoinedEvent javaInstance) {
      return new LuaPlayerJoinedEvent<>(this, javaInstance);
    }
  }

  public LuaPlayerJoinedEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("player", this::getPlayer);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getPlayer() {
    class_3222 result = getDelegate().player();
    return getConverters().toLua(result);
  }
}
