package net.wizardsoflua.lua.classes;

import net.minecraft.class_1268;
import net.minecraft.class_3222;
import net.wizardsoflua.event.PlayerUseBlockEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerUseBlockEvent< //
    J extends PlayerUseBlockEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<PlayerUseBlockEvent, LuaPlayerUseBlockEvent<PlayerUseBlockEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerUseBlockEvent", spellScope, null);
    }

    @Override
    protected final LuaPlayerUseBlockEvent<PlayerUseBlockEvent, Class> createNewLuaInstance(
        PlayerUseBlockEvent javaInstance) {
      return new LuaPlayerUseBlockEvent<>(this, javaInstance);
    }
  }

  public LuaPlayerUseBlockEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("world", this::getWorld);
    addReadOnly("player", this::getPlayer);
    addReadOnly("hand", this::getHand);
    addReadOnly("hitResult", this::getBlockHitResult);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getWorld() {
    return getConverters().toLua(getDelegate().world());
  }

  private Object getPlayer() {
    class_3222 result = getDelegate().player();
    return getConverters().toLua(result);
  }

  private Object getHand() {
    class_1268 result = getDelegate().hand();
    return getConverters().toLua(result);
  }

  private Object getBlockHitResult() {
    return getConverters().toLua(getDelegate().hitResult());
  }
}
