package net.wizardsoflua.lua.classes;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.wizardsoflua.event.PlayerUseEntityEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerUseEntityEvent< //
    J extends PlayerUseEntityEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<PlayerUseEntityEvent, LuaPlayerUseEntityEvent<PlayerUseEntityEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerUseEntityEvent", spellScope, null);
    }

    @Override
    protected final LuaPlayerUseEntityEvent<PlayerUseEntityEvent, Class> createNewLuaInstance(
        PlayerUseEntityEvent javaInstance) {
      return new LuaPlayerUseEntityEvent<>(this, javaInstance);
    }
  }

  public LuaPlayerUseEntityEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("world", this::getWorld);
    addReadOnly("player", this::getPlayer);
    addReadOnly("hand", this::getHand);
    addReadOnly("entity", this::getEntity);
    addReadOnly("hitResult", this::getEntityHitResult);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getWorld() {
    return getConverters().toLua(getDelegate().world());
  }

  private Object getPlayer() {
    class_3222 result = getDelegate().player();
    return getConverters().toLua(result);
  }

  private Object getHand() {
    class_1268 result = getDelegate().hand();
    return getConverters().toLua(result);
  }

  private Object getEntity() {
    class_1297 result = getDelegate().entity();
    return getConverters().toLua(result);
  }

  private Object getEntityHitResult() {
    return getConverters().toLuaNullable(getDelegate().hitResult());
  }
}
