package net.wizardsoflua.lua.classes;

import static java.util.Objects.requireNonNull;
import java.util.Map;
import net.minecraft.class_2168;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.impl.DefaultTable;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.command.dynamic.DynamicCommandManager;
import net.wizardsoflua.extension.spell.api.resource.LuaConverters;
import net.wizardsoflua.lua.function.NamedFunction0;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.module.wol.LogTarget;
import net.wizardsoflua.lua.module.wol.WolModule;
import net.wizardsoflua.lua.table.DelegatingLuaTable;
import net.wizardsoflua.spell.SpellScope;

public class WolModuleLuaTable extends DelegatingLuaTable<WolModule> {
  private final SpellScope spellScope;

  public WolModuleLuaTable(WolModule delegate, LuaConverters converters, SpellScope spellScope) {
    super(delegate, converters, true);
    this.spellScope = requireNonNull(spellScope, "spellScope");;

    addReadOnly("version", this::getVersion);
    add("log", this::getLog, this::setLog);

    addFunction(new SetCommandFunction());
    addFunction(new RemoveCommandFunction());
    addFunction(new ListCommandsFunction());
  }

  private Object getVersion() {
    return getConverters().toLuaNullable(getDelegate().getVersion());
  }

  private Object getLog() {
    return getConverters().toLua(getDelegate().getLog());
  }

  private void setLog(Object luaObject) {
    LogTarget value = getConverters().toJava(LogTarget.class, luaObject, "log");
    getDelegate().setLog(value);
  }

  private class SetCommandFunction extends NamedFunction1 {
    @Override
    public String getName() {
      return "setCommand";
    }

    @Override
    public void invoke(ExecutionContext ctx, Object tableObj) throws ResolvedControlThrowable {
      Table table = getConverters().castTo(Table.class, tableObj, 1, "command", getName());
      String id =
          getConverters().toJava(String.class, table.rawget("id"), 1, "command.id", getName());
      int level = getConverters()
          .toJavaOptional(int.class, table.rawget("level"), 2, "command.level", getName())
          .orElse(0);
      String pattern = getConverters().toJava(String.class, table.rawget("pattern"), 3,
          "command.pattern", getName());
      String code =
          getConverters().toJava(String.class, table.rawget("code"), 4, "command.code", getName());
      class_2168 src = spellScope.getCommandSource();
      getDelegate().getCommandManager().set(id, pattern, code, src, level);
      ctx.getReturnBuffer().setTo(true);
    }
  }

  private class RemoveCommandFunction extends NamedFunction1 {
    @Override
    public String getName() {
      return "removeCommand";
    }

    @Override
    public void invoke(ExecutionContext ctx, Object idObj) throws ResolvedControlThrowable {
      String id = getConverters().toJava(String.class, idObj, 1, "id", getName());

      class_2168 src = spellScope.getCommandSource();
      boolean result = getDelegate().getCommandManager().remove(id, src);
      ctx.getReturnBuffer().setTo(result);
    }
  }

  private class ListCommandsFunction extends NamedFunction0 {
    @Override
    public String getName() {
      return "listCommands";
    }

    @Override
    public void invoke(ExecutionContext ctx) throws ResolvedControlThrowable {
      Map<String, DynamicCommandManager.CommandDef> defs =
          getDelegate().getCommandManager().getAll();

      Table table = DefaultTable.factory().newTable();
      int index = 0;
      for (var e : defs.entrySet()) {
        Table entry = DefaultTable.factory().newTable();
        String key = e.getKey();
        entry.rawset("id", getConverters().toLua(key));
        entry.rawset("level", getConverters().toLua(e.getValue().level()));
        entry.rawset("pattern", getConverters().toLuaNullable(e.getValue().pattern()));
        entry.rawset("code", getConverters().toLua(e.getValue().code()));
        table.rawset(++index, entry);
      }
      ctx.getReturnBuffer().setTo(table);
    }
  }
}
