package net.wizardsoflua.lua.module.types;

import static java.util.Objects.requireNonNull;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.TableFactory;
import net.wizardsoflua.extension.spell.api.resource.LuaTypes;
import net.wizardsoflua.lua.BadArgumentException;

public class TypesModule {
  private final LuaTypes types;
  private final Table env;
  private final TableFactory tableFactory;
  private final Table objectClassMetaTable;

  public TypesModule(LuaTypes types, Table env, TableFactory tableFactory) {
    this.types = requireNonNull(types, "types");;
    this.env = requireNonNull(env, "env");
    this.tableFactory = requireNonNull(tableFactory, "tableFactory");
    this.objectClassMetaTable = tableFactory.newTable();
  }

  public LuaTypes getTypes() {
    return types;
  }

  public Table declare(String className, Table metatable) {
    if (env.rawget(className) != null) {
      throw new BadArgumentException(
          "a global variable with name '" + className + "' is already defined", 1, "className",
          "declare");
    }
    if (metatable == null) {
      metatable = objectClassMetaTable;
    }
    Table classTable = tableFactory.newTable();
    classTable.rawset("__index", classTable);
    classTable.setMetatable(metatable);
    getTypes().registerLuaClass(className, classTable);
    env.rawset(className, classTable);
    return classTable;
  }

  public boolean instanceOf(Table classTable, Object object) {
    if (object == null) {
      return false;
    }
    if (!(object instanceof Table)) {
      return false;
    }
    Table metatable = ((Table) object).getMetatable();
    return classTable.equals(metatable) || instanceOf(classTable, metatable);
  }

  public String type(Object luaObject) {
    return getTypes().getLuaTypeNameOfLuaObject(luaObject);
  }
}
