package net.wizardsoflua.lua.module.wol;

import static java.util.Objects.requireNonNull;
import java.util.function.Supplier;
import net.wizardsoflua.command.dynamic.DynamicCommandManager;

/**
 * Core module exposed to Lua as `WizardsOfLua`, now carrying an injected DynamicCommandManager.
 */
public class WolModule {
  public static final String NAME = "WizardsOfLua";

  private final Supplier<String> versionSupplier;
  private final Supplier<DynamicCommandManager> commandManagerSupplier;
  private LogTarget logTarget = LogTarget.source;

  public WolModule(Supplier<String> versionSupplier,
      Supplier<DynamicCommandManager> commandManagerSupplier) {
    this.versionSupplier = requireNonNull(versionSupplier, "versionSupplier");
    this.commandManagerSupplier = requireNonNull(commandManagerSupplier, "commandManager");
  }

  public String getVersion() {
    return versionSupplier.get();
  }

  public LogTarget getLog() {
    return logTarget;
  }

  public void setLog(LogTarget logTarget) {
    this.logTarget = requireNonNull(logTarget, "logTarget");
  }

  public DynamicCommandManager getCommandManager() {
    return commandManagerSupplier.get();
  }
}
