package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;

import net.minecraft.class_2495;
import net.sandius.rembulan.Conversions;
import net.sandius.rembulan.Table;

public class NbtIntArrayMerger implements NbtMerger<class_2495> {

  private final NbtConverter converter;

  public NbtIntArrayMerger(NbtConverter converter) {
    this.converter = checkNotNull(converter, "converter == null!");
  }

  @Override
  public class_2495 merge(class_2495 nbt, Object data, String key, String path) {
    if (data instanceof Table) {
      Table table = (Table) data;
      if (NbtConverter.isArray(table)) {
        long len = table.rawlen();
        if (len > Integer.MAX_VALUE) {
          throw new UnsupportedOperationException(
              "Can't merge arrays with more that Integer.MAX_VALUE elements!");
        }
        int[] arr = new int[(int) len];
        for (int i = 0; i < arr.length; ++i) {
          Object newLuaValue = table.rawget(i + 1);
          if (newLuaValue != null) {
            int newNbtValue = Conversions.integerValueOf(newLuaValue).intValue();
            arr[i] = newNbtValue;
          }
        }
        class_2495 result = new class_2495(arr);
        return result;
      }
    }
    throw converter.conversionException(path, data, "table");
  }

}
