package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;

import net.minecraft.class_2497;

public class NbtIntMerger implements NbtMerger<class_2497> {
  private final NbtConverter converter;

  public NbtIntMerger(NbtConverter converter) {
    this.converter = checkNotNull(converter, "converter == null!");
  }

  @Override
  public class_2497 merge(class_2497 nbt, Object data, String key, String path) {
    if (data instanceof Number) {
      return NbtConverter.toNbt(((Number) data).intValue());
    }
    throw converter.conversionException(path, data, "number");
  }
}
