package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;

import net.minecraft.class_2519;
import net.sandius.rembulan.ByteString;

public class NbtStringMerger implements NbtMerger<class_2519> {
  private final NbtConverter converter;

  public NbtStringMerger(NbtConverter converter) {
    this.converter = checkNotNull(converter, "converter == null!");
  }

  @Override
  public class_2519 merge(class_2519 nbt, Object data, String key, String path) {
    if (data instanceof ByteString) {
      return NbtConverter.toNbt((ByteString) data);
    }
    if (data instanceof String) {
      return NbtConverter.toNbt((String) data);
    }
    throw converter.conversionException(path, data, "string");
  }
}
