package net.wizardsoflua.mixin.impls;

import java.util.Objects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.wizardsoflua.mixin.interfaces.ExtendedEntity;

@Mixin(net.minecraft.class_1297.class)
public abstract class EntityMixin implements ExtendedEntity {
  private static final String WOL_EXTRA_KEY = "wol:extra";

  @Unique
  private class_2487 extra = new class_2487();

  @Override
  public class_2487 getExtra() {
    return extra;
  }

  @Override
  public void setExtra(class_2487 extra) {
    this.extra = Objects.requireNonNull(extra, "extra");
  }

  @Inject(method = "writeNbt(Lnet/minecraft/nbt/NbtCompound;)Lnet/minecraft/nbt/NbtCompound;",
      at = @At("TAIL"))
  private void saveExtraData(class_2487 tag, CallbackInfoReturnable<class_2487> ci) {
    class_2487 result = ci.getReturnValue();
    if (!extra.method_33133()) {
      result.method_10566(WOL_EXTRA_KEY, extra);
    }
  }

  @Inject(method = "readNbt(Lnet/minecraft/nbt/NbtCompound;)V", at = @At("TAIL"))
  private void loadExtraData(class_2487 tag, CallbackInfo ci) {
    if (tag.method_10573(WOL_EXTRA_KEY, class_2520.field_33260)) {
      extra = tag.method_10562(WOL_EXTRA_KEY);
    } else if (!extra.method_33133()) {
      extra = new class_2487();
    }
  }
}
