package net.wizardsoflua.mixin.impls;

import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import net.minecraft.class_2960;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.wizardsoflua.mixin.interfaces.WolStructureTemplateManager;

@Mixin(class_3485.class)
public abstract class StructureTemplateManagerMixin implements WolStructureTemplateManager {
  @Shadow @Final
  private Map<class_2960, Optional<class_3499>> templates;

  @Shadow
  public abstract boolean saveTemplate(class_2960 id);

  @Unique
  @Override
  public @Nullable class_2960 getTemplateId(class_3499 template) {
    for (var entry : templates.entrySet()) {
      Optional<class_3499> optional = entry.getValue();
      if (optional.isPresent() && optional.get() == template) {
        return entry.getKey();
      }
    }
    return null;
  }
  
  @Override
  public boolean saveTemplate(class_2960 id, class_3499 template) {
    templates.put(id, Optional.of(template));
    return saveTemplate(id);
  }
}
