package net.wizardsoflua.spell;

import static java.util.Objects.requireNonNull;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import com.google.common.primitives.Ints;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.sandius.rembulan.ByteString;
import net.sandius.rembulan.Conversions;
import net.sandius.rembulan.Table;
import net.wizardsoflua.WolDirectories;
import net.wizardsoflua.chunk.ChunkForceManager;
import net.wizardsoflua.extension.spell.spi.JavaToLuaConverter;
import net.wizardsoflua.extension.spell.spi.LuaConverter;
import net.wizardsoflua.extension.spell.spi.LuaToJavaConverter;
import net.wizardsoflua.filesystem.WolServerFileSystem;
import net.wizardsoflua.lua.Converters;
import net.wizardsoflua.lua.classes.AbstractLuaClass;
import net.wizardsoflua.lua.classes.AbstractLuaInstance;
import net.wizardsoflua.lua.classes.LuaAfterLivingEntityDamageEvent;
import net.wizardsoflua.lua.classes.LuaAfterLivingEntityDeathEvent;
import net.wizardsoflua.lua.classes.LuaAfterPlayerBlockBreakEvent;
import net.wizardsoflua.lua.classes.LuaAfterPlayerRespawnEvent;
import net.wizardsoflua.lua.classes.LuaBeforeLivingEntityDamageEvent;
import net.wizardsoflua.lua.classes.LuaBeforeLivingEntityDeathEvent;
import net.wizardsoflua.lua.classes.LuaBeforePlayerBlockBreakEvent;
import net.wizardsoflua.lua.classes.LuaBlock;
import net.wizardsoflua.lua.classes.LuaBlockEntity;
import net.wizardsoflua.lua.classes.LuaBlockEntityType;
import net.wizardsoflua.lua.classes.LuaBlockHitResult;
import net.wizardsoflua.lua.classes.LuaBlockType;
import net.wizardsoflua.lua.classes.LuaChatMessageEvent;
import net.wizardsoflua.lua.classes.LuaChunkLoadEvent;
import net.wizardsoflua.lua.classes.LuaChunkUnloadEvent;
import net.wizardsoflua.lua.classes.LuaCustomEvent;
import net.wizardsoflua.lua.classes.LuaDamageSource;
import net.wizardsoflua.lua.classes.LuaEntity;
import net.wizardsoflua.lua.classes.LuaEntityDespawnEvent;
import net.wizardsoflua.lua.classes.LuaEntityHitResult;
import net.wizardsoflua.lua.classes.LuaEntitySpawnEvent;
import net.wizardsoflua.lua.classes.LuaEntityType;
import net.wizardsoflua.lua.classes.LuaEventInterceptor;
import net.wizardsoflua.lua.classes.LuaEventQueue;
import net.wizardsoflua.lua.classes.LuaFilesystem;
import net.wizardsoflua.lua.classes.LuaHitResult;
import net.wizardsoflua.lua.classes.LuaInstanceCache;
import net.wizardsoflua.lua.classes.LuaItem;
import net.wizardsoflua.lua.classes.LuaItemEntity;
import net.wizardsoflua.lua.classes.LuaItemType;
import net.wizardsoflua.lua.classes.LuaLivingEntity;
import net.wizardsoflua.lua.classes.LuaMobEntity;
import net.wizardsoflua.lua.classes.LuaPermissioCheckEvent;
import net.wizardsoflua.lua.classes.LuaPlayer;
import net.wizardsoflua.lua.classes.LuaPlayerAttackBlockEvent;
import net.wizardsoflua.lua.classes.LuaPlayerAttackEntityEvent;
import net.wizardsoflua.lua.classes.LuaPlayerChangeWorldEvent;
import net.wizardsoflua.lua.classes.LuaPlayerDisconnectedEvent;
import net.wizardsoflua.lua.classes.LuaPlayerDropItemEvent;
import net.wizardsoflua.lua.classes.LuaPlayerDropSelectedItemEvent;
import net.wizardsoflua.lua.classes.LuaPlayerHandSwingEvent;
import net.wizardsoflua.lua.classes.LuaPlayerInventory;
import net.wizardsoflua.lua.classes.LuaPlayerJoinedEvent;
import net.wizardsoflua.lua.classes.LuaPlayerUseBlockEvent;
import net.wizardsoflua.lua.classes.LuaPlayerUseEntityEvent;
import net.wizardsoflua.lua.classes.LuaPlayerUseItemEvent;
import net.wizardsoflua.lua.classes.LuaServer;
import net.wizardsoflua.lua.classes.LuaSpell;
import net.wizardsoflua.lua.classes.LuaSpellFinishEvent;
import net.wizardsoflua.lua.classes.LuaStructure;
import net.wizardsoflua.lua.classes.LuaTrace;
import net.wizardsoflua.lua.classes.LuaWorld;
import net.wizardsoflua.lua.classes.TypesModuleLuaTable;
import net.wizardsoflua.lua.classes.WolModuleLuaTable;
import net.wizardsoflua.lua.module.types.Types;
import net.wizardsoflua.lua.module.types.TypesModule;
import net.wizardsoflua.lua.module.wol.WolModule;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.lua.table.DefaultTableBuilder;
import net.wizardsoflua.world.WorldChunkTracker;

public class SpellScope {
  private final SpellRegistry spellRegistry;
  private final class_3218 world;
  private final ChunkForceManager chunkForceManager;
  private final WolDirectories directories;
  private final WolModule wolModule;
  private final WorldChunkTracker worldChunkTracker;
  private final class_2168 commandSource;
  private final WolServerFileSystem wolServerFileSystem;
  private final Types types;
  private final Converters converters;
  private final NbtConverter nbtConverter;
  private final LuaInstanceCache instanceCache = new LuaInstanceCache();
  private Spell spell;

  public SpellScope(SpellRegistry spellRegistry, ChunkForceManager chunkForceManager,
      WolDirectories directories, WolModule wolModule, WorldChunkTracker worldChunkTracker,
      class_2168 commandSource) {
    this.spellRegistry = requireNonNull(spellRegistry, "spellRegistry");
    this.chunkForceManager = requireNonNull(chunkForceManager, "chunkForceManager");;
    this.directories = requireNonNull(directories, "directories");
    this.wolModule = requireNonNull(wolModule, "wolModule");
    this.worldChunkTracker = requireNonNull(worldChunkTracker, "worldChunkTracker");
    this.commandSource = requireNonNull(commandSource, "commandSource");
    this.world = requireNonNull(commandSource.method_9225(), "world");
    wolServerFileSystem =
        new WolServerFileSystem(world.method_8503().method_27050(class_5218.field_24188).normalize());
    types = new Types(this::getConverters);
    converters = new Converters(this::getTypes);
    nbtConverter = new NbtConverter(types);
    addClasses();
    addAdditionalConverters();
  }

  void setSpell(Spell spell) {
    this.spell = requireNonNull(spell, "spell");;
  }

  public Spell getSpell() {
    return requireNonNull(spell, "spell");
  }

  public class_3218 getWorld() {
    return world;
  }

  public WorldChunkTracker getWorldChunkTracker() {
    return worldChunkTracker;
  }

  public class_2168 getCommandSource() {
    return commandSource;
  }

  public class_2168 getTopmostCommandSource() {
    var result = commandSource;
    while (result instanceof SpellServerCommandSource scs) {
      result = scs.getSpell().getSpellScope().getCommandSource();
    }
    return result;
  }

  public @Nullable class_1297 getOwner() {
    if (commandSource instanceof SpellServerCommandSource spellSource) {
      return spellSource.getSpell().getOwner();
    }
    return commandSource.method_9228();
  }

  public ChunkForceManager getChunkForceManager() {
    return chunkForceManager;
  }

  public WolServerFileSystem getWolServerFileSystem() {
    return wolServerFileSystem;
  }

  public WolDirectories getDirectories() {
    return directories;
  }

  public WolModule getWolModule() {
    return wolModule;
  }

  public Converters getConverters() {
    return converters;
  }

  public Types getTypes() {
    return types;
  }

  public NbtConverter getNbtConverter() {
    return nbtConverter;
  }

  public SpellRegistry getSpellRegistry() {
    return spellRegistry;
  }

  public LuaInstanceCache getInstanceCache() {
    return instanceCache;
  }

  private void addClasses() {
    LuaEntity.Class entityLuaClass = add(new LuaEntity.Class(this));
    LuaLivingEntity.Class livingEntityLuaClass =
        add((new LuaLivingEntity.Class(this, entityLuaClass)));
    add((new LuaMobEntity.Class(this, livingEntityLuaClass)));
    LuaHitResult.Class luaHitResultClass = add(new LuaHitResult.Class(this));

    add(new LuaAfterLivingEntityDamageEvent.Class(this));
    add(new LuaAfterLivingEntityDeathEvent.Class(this));
    add(new LuaAfterPlayerBlockBreakEvent.Class(this));
    add(new LuaAfterPlayerRespawnEvent.Class(this));
    add(new LuaBeforeLivingEntityDamageEvent.Class(this));
    add(new LuaBeforeLivingEntityDeathEvent.Class(this));
    add(new LuaBeforePlayerBlockBreakEvent.Class(this));
    add(new LuaBlock.Class(this));
    add(new LuaBlockEntity.Class(this));
    add(new LuaBlockEntityType.Class(this));
    add(new LuaBlockHitResult.Class(this, luaHitResultClass));
    add(new LuaBlockType.Class(this));
    add(new LuaChatMessageEvent.Class(this));
    add(new LuaChunkLoadEvent.Class(this));
    add(new LuaChunkUnloadEvent.Class(this));
    add(new LuaCustomEvent.Class(this));
    add(new LuaDamageSource.Class(this));
    add(new LuaEntityDespawnEvent.Class(this));
    add(new LuaEntityHitResult.Class(this, luaHitResultClass));
    add(new LuaEntityType.Class(this));
    add(new LuaEntitySpawnEvent.Class(this));
    add(new LuaEventInterceptor.Class(this));
    add(new LuaEventQueue.Class(this));
    add(new LuaFilesystem.Class(this));
    add(new LuaTrace.Class(this));
    add(new LuaItemType.Class(this));
    add(new LuaItemEntity.Class(this, entityLuaClass));
    add(new LuaItem.Class(this));
    add(new LuaPermissioCheckEvent.Class(this));
    add(new LuaPlayer.Class(this, livingEntityLuaClass));
    add(new LuaPlayerAttackBlockEvent.Class(this));
    add(new LuaPlayerAttackEntityEvent.Class(this));
    add(new LuaPlayerChangeWorldEvent.Class(this));
    add(new LuaPlayerDisconnectedEvent.Class(this));
    add(new LuaPlayerDropItemEvent.Class(this));
    add(new LuaPlayerDropSelectedItemEvent.Class(this));
    add(new LuaPlayerHandSwingEvent.Class(this));
    add(new LuaPlayerInventory.Class(this));
    add(new LuaPlayerUseBlockEvent.Class(this));
    add(new LuaPlayerUseEntityEvent.Class(this));
    add(new LuaPlayerUseItemEvent.Class(this));
    add(new LuaPlayerJoinedEvent.Class(this));
    add(new LuaServer.Class(this));
    add(new LuaSpell.Class(this));
    add(new LuaSpellFinishEvent.Class(this));
    add(new LuaStructure.Class(this));
    add(new LuaWorld.Class(this));
  }

  private void addAdditionalConverters() {
    converters.registerLuaConverter("Types", TypesModule.class, TypesModuleLuaTable.class,
        TypesModuleLuaTable::getDelegate, it -> new TypesModuleLuaTable(it, converters));
    converters.registerLuaConverter(WolModule.NAME, WolModule.class, WolModuleLuaTable.class,
        WolModuleLuaTable::getDelegate, it -> new WolModuleLuaTable(it, converters, this));
    converters.registerLuaConverter("Vec3", class_243.class, Table.class, (Table luaObj) -> {
      double x = Conversions.floatValueOf(luaObj.rawget("x"));
      double y = Conversions.floatValueOf(luaObj.rawget("y"));
      double z = Conversions.floatValueOf(luaObj.rawget("z"));
      return new class_243(x, y, z);
    }, (javaObj) -> {
      DefaultTableBuilder builder = new DefaultTableBuilder();
      builder.add("x", javaObj.field_1352);
      builder.add("y", javaObj.field_1351);
      builder.add("z", javaObj.field_1350);
      Table classTable = types.getLuaClassTableForName("Vec3");
      builder.setMetatable(classTable);
      return builder.build();
    });
    converters.registerJavaToLuaConverter(new JavaToLuaConverter<class_2382>() {
      @Override
      public Class<class_2382> getJavaClass() {
        return class_2382.class;
      }

      @Override
      public Object getLuaInstance(class_2382 javaInstance) {
        class_243 vec3d = class_243.method_24954(javaInstance);
        return converters.toLua(vec3d);
      }
    });
    converters.registerLuaToJavaConverter(new LuaToJavaConverter<class_2338, Table>() {
      @Override
      public Class<class_2338> getJavaClass() {
        return class_2338.class;
      }

      @Override
      public Class<Table> getLuaClass() {
        return Table.class;
      }

      @Override
      public class_2338 getJavaInstance(Table luaObj) {
        int x = Ints.saturatedCast(Conversions.integerValueOf(luaObj.rawget("x")));
        int y = Ints.saturatedCast(Conversions.integerValueOf(luaObj.rawget("y")));
        int z = Ints.saturatedCast(Conversions.integerValueOf(luaObj.rawget("z")));
        return new class_2338(x, y, z);
      }
    });
    converters.registerLuaConverter(new LuaConverter<class_1304, ByteString>() {
      @Override
      public Class<class_1304> getJavaClass() {
        return class_1304.class;
      }

      @Override
      public Class<ByteString> getLuaClass() {
        return ByteString.class;
      }

      @Override
      public class_1304 getJavaInstance(ByteString luaInstance) {
        String name = luaInstance.toString();
        return class_1304.method_5924(name);
      }

      @Override
      public ByteString getLuaInstance(class_1304 javaInstance) {
        return ByteString.of(javaInstance.method_15434());
      }
    });
  }

  private <J, L extends AbstractLuaInstance<J, C>, C extends AbstractLuaClass<J, L>> C add(
      C luaClass) {
    String name = luaClass.getName();
    Class<J> classJ = luaClass.getJavaClass();
    Class<L> classL = luaClass.getLuaInstanceClass();
    Function<J, Object> toLua = luaClass::toLua;
    Function<L, J> toJava = luaClass::toJava;
    types.registerLuaClass(name, luaClass);
    converters.registerJavaToLuaConverter(new JavaToLuaConverter<J>() {
      @Override
      public Class<J> getJavaClass() {
        return classJ;
      }

      @Override
      public Object getLuaInstance(J javaInstance) {
        return toLua.apply(javaInstance);
      }
    });
    converters.registerLuaToJavaConverter(new LuaToJavaConverter<J, L>() {
      @Override
      public Class<J> getJavaClass() {
        return classJ;
      }

      @Override
      public Class<L> getLuaClass() {
        return classL;
      }

      @Override
      public J getJavaInstance(L luaInstance) {
        return toJava.apply(luaInstance);
      }
    });
    return luaClass;
  }
}
