/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.classes;

import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.filesystem.WolServerFileSystem;
import net.wizardsoflua.lua.classes.AbstractLuaClass;
import net.wizardsoflua.lua.classes.AbstractLuaInstance;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.function.NamedFunction3;
import net.wizardsoflua.mixin.interfaces.WolStructureTemplateManager;
import net.wizardsoflua.spell.SpellScope;

public class LuaServer<J extends MinecraftServer, LC extends AbstractLuaClass<?, ?>>
extends AbstractLuaInstance<J, LC> {
    public LuaServer(LC luaClass, J javaInstance) {
        super(luaClass, javaInstance, true);
        this.addReadOnly("version", this::getVersion);
        this.addReadOnly("filesystem", this::getFilesystem);
        this.addReadOnly("players", this::getPlayers);
    }

    private Object getVersion() {
        return this.getConverters().toLua(((MinecraftServer)this.getDelegate()).method_3827());
    }

    private Object getFilesystem() {
        WolServerFileSystem result = ((AbstractLuaClass)((Object)this.getLuaClass())).getWolServerFileSystem();
        return this.getConverters().toLua(result);
    }

    private Object getPlayers() {
        List players = ((MinecraftServer)this.getDelegate()).method_3760().method_14571();
        return this.getConverters().toLua(players);
    }

    public static class Class
    extends AbstractLuaClass<MinecraftServer, LuaServer<MinecraftServer, Class>> {
        public Class(SpellScope spellScope) {
            super("Server", spellScope, null);
            this.addFunction(new GetWorldFunction());
            this.addFunction(new LoadStructureFunction());
            this.addFunction(new SaveStructureFunction());
        }

        @Override
        protected final LuaServer<MinecraftServer, Class> createNewLuaInstance(MinecraftServer javaInstance) {
            return new LuaServer<MinecraftServer, Class>(this, javaInstance);
        }

        class GetWorldFunction
        extends NamedFunction2 {
            GetWorldFunction() {
            }

            @Override
            public String getName() {
                return "getWorld";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object dimensionArg) throws ResolvedControlThrowable {
                LuaServer self = Class.this.getConverters().castTo(LuaServer.class, selfArg, 1, "self", this.getName());
                String dimension = Class.this.getConverters().toJava(String.class, dimensionArg, 2, "dimension", this.getName());
                class_5321 regKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)dimension));
                class_3218 world = ((MinecraftServer)self.getDelegate()).method_3847(regKey);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLua(world));
            }
        }

        class LoadStructureFunction
        extends NamedFunction2 {
            LoadStructureFunction() {
            }

            @Override
            public String getName() {
                return "loadStructure";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object nameArg) throws ResolvedControlThrowable {
                LuaServer self = Class.this.getConverters().castTo(LuaServer.class, selfArg, 1, "self", this.getName());
                String name = Class.this.getConverters().toJava(String.class, nameArg, 2, "name", this.getName());
                class_3218 world = Class.this.getWorld();
                class_3485 mgr = world.method_14183();
                class_2960 id = class_2960.method_60654((String)name);
                class_3499 result = (class_3499)mgr.method_15094(id).orElseThrow(() -> {
                    throw new IllegalArgumentException("Can't find structure \"" + name + "\"");
                });
                context.getReturnBuffer().setTo(Class.this.getConverters().toLua(result));
            }
        }

        class SaveStructureFunction
        extends NamedFunction3 {
            SaveStructureFunction() {
            }

            @Override
            public String getName() {
                return "saveStructure";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object nameArg, Object structArg) throws ResolvedControlThrowable {
                LuaServer self = Class.this.getConverters().castTo(LuaServer.class, selfArg, 1, "self", this.getName());
                String name = Class.this.getConverters().toJava(String.class, nameArg, 2, "name", this.getName());
                class_3499 template = Class.this.getConverters().toJava(class_3499.class, structArg, 3, "struct", this.getName());
                class_3218 world = Class.this.getWorld();
                class_3485 mgr = world.method_14183();
                class_2960 id = class_2960.method_60654((String)name);
                ((WolStructureTemplateManager)mgr).saveTemplate(id, template);
                Path file = mgr.method_15085(id, ".nbt");
                Path rootDir = Class.this.getWolServerFileSystem().getRootFolder();
                Path relativeFilePath = rootDir.relativize(file);
                String result = relativeFilePath.toString();
                context.getReturnBuffer().setTo(Class.this.getConverters().toLua(result));
            }
        }
    }
}

