/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.classes;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3730;
import net.minecraft.class_3793;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.sandius.rembulan.LuaRuntimeException;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.TableFactory;
import net.sandius.rembulan.impl.DefaultTable;
import net.sandius.rembulan.impl.NonsuspendableFunctionException;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.IllegalOperationAttemptException;
import net.sandius.rembulan.runtime.LuaFunction;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.sandius.rembulan.runtime.Resumable;
import net.sandius.rembulan.runtime.UnresolvedControlThrowable;
import net.wizardsoflua.event.CustomEvent;
import net.wizardsoflua.lua.RaycastUtil;
import net.wizardsoflua.lua.classes.AbstractLuaClass;
import net.wizardsoflua.lua.classes.AbstractLuaInstance;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.function.NamedFunction3;
import net.wizardsoflua.lua.function.NamedFunction4;
import net.wizardsoflua.lua.function.NamedFunctionAnyArg;
import net.wizardsoflua.lua.module.event.EventInterceptor;
import net.wizardsoflua.lua.module.event.EventQueue;
import net.wizardsoflua.lua.scheduling.LuaScheduler;
import net.wizardsoflua.lua.table.TableUtils;
import net.wizardsoflua.spell.CommandTrace;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellScope;
import net.wizardsoflua.util.WolDirection;
import org.jetbrains.annotations.Nullable;

public class LuaSpell<J extends Spell, LC extends AbstractLuaClass<?, ?>>
extends AbstractLuaInstance<J, LC> {
    public LuaSpell(LC luaClass, J javaInstance) {
        super(luaClass, javaInstance, true);
        this.addReadOnly("world", this::getWorld);
        this.addReadOnly("id", this::getId);
        this.add("name", this::getName, this::setName);
        this.addReadOnly("owner", this::getOwner);
        this.addReadOnly("age", this::getAge);
        this.add("pos", this::getPos, this::setPos);
        this.addReadOnly("lookVec", this::getLookVec);
        this.add("pitch", this::getPitch, this::setPitch);
        this.add("yaw", this::getYaw, this::setYaw);
        this.add("velocity", this::getVelocity, this::setVelocity);
        this.add("block", this::getBlock, this::setBlock);
        this.addReadOnly("blockEntity", this::getBlockEntity);
        this.add("forceChunk", this::isForceChunk, this::setForceChunk);
        this.add("visible", this::isVisible, this::setVisible);
        this.addReadOnly("server", this::getServer);
        this.addReadOnly("facing", this::getFacing);
        this.add("tickLimit", this::getTickLimit, this::setTickLimit);
        this.addReadOnly("biome", this::getBiome);
    }

    private Object getWorld() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).getWorld());
    }

    private Object getId() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).getSid());
    }

    private Object getName() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).getName());
    }

    private void setName(Object luaObject) {
        String name = this.getConverters().toJava(String.class, luaObject, "name");
        ((Spell)this.getDelegate()).setName(name);
    }

    private Object getOwner() {
        return this.getConverters().toLuaNullable(((Spell)this.getDelegate()).getOwner());
    }

    private Object getAge() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).getAge());
    }

    private Object getPos() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).getPos());
    }

    private void setPos(Object luaObject) {
        class_243 pos = this.getConverters().toJava(class_243.class, luaObject, "pos");
        ((Spell)this.getDelegate()).setPos(pos);
    }

    private Object getLookVec() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).getLookVector());
    }

    private Object getPitch() {
        return this.getConverters().toLua(Float.valueOf(((Spell)this.getDelegate()).getPitch()));
    }

    private void setPitch(Object luaObject) {
        float pitch = this.getConverters().toJava(Float.TYPE, luaObject, "pitch").floatValue();
        ((Spell)this.getDelegate()).setPitch(pitch);
    }

    private Object getYaw() {
        return this.getConverters().toLua(Float.valueOf(((Spell)this.getDelegate()).getYaw()));
    }

    private void setYaw(Object luaObject) {
        float yaw = this.getConverters().toJava(Float.TYPE, luaObject, "yaw").floatValue();
        ((Spell)this.getDelegate()).setYaw(yaw);
    }

    private Object getVelocity() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).getVelocity());
    }

    private void setVelocity(Object luaObject) {
        class_243 velocity = this.getConverters().toJava(class_243.class, luaObject, "velocity");
        ((Spell)this.getDelegate()).setVelocity(velocity);
    }

    private Object getBlock() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).getBlockState());
    }

    private void setBlock(Object luaObject) {
        class_2680 blockState = this.getConverters().toJava(class_2680.class, luaObject, "blockState");
        ((Spell)this.getDelegate()).setBlockState(blockState);
    }

    private Object getBlockEntity() {
        return this.getConverters().toLuaNullable(((Spell)this.getDelegate()).getBlockEntity());
    }

    private Object isForceChunk() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).isForceChunk());
    }

    private void setForceChunk(Object luaObject) {
        ((Spell)this.getDelegate()).setForceChunk(this.getConverters().toJava(Boolean.TYPE, luaObject, "forceChunk"));
    }

    private Object isVisible() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).isVisible());
    }

    private void setVisible(Object luaObject) {
        ((Spell)this.getDelegate()).setVisible(this.getConverters().toJava(Boolean.TYPE, luaObject, "visible"));
    }

    private Object getServer() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).getWorld().method_8503());
    }

    private Object getFacing() {
        return this.getConverters().toLua(class_2350.method_10150((double)((Spell)this.getDelegate()).getYaw()));
    }

    private Object getTickLimit() {
        return this.getConverters().toLua(((Spell)this.getDelegate()).getProgram().getLuaTicksLimit());
    }

    private void setTickLimit(Object luaObject) {
        long tickLimit = this.getConverters().toJava(Long.class, luaObject, "tickLimit");
        ((Spell)this.getDelegate()).getProgram().setLuaTicksLimit(tickLimit);
    }

    private Object getBiome() {
        class_3218 world = ((Spell)this.getDelegate()).getWorld();
        class_6880 biome = world.method_23753(((Spell)this.getDelegate()).getBlockPos());
        String result = ((class_5321)biome.method_40230().get()).method_29177().method_43903();
        return this.getConverters().toLua(result);
    }

    public static class Class
    extends AbstractLuaClass<Spell, LuaSpell<Spell, Class>> {
        public Class(SpellScope spellScope) {
            super("Spell", spellScope, null);
            this.addFunction(new ExecuteFunction());
            this.addFunction(new ExecuteSilentFunction());
            this.addFunction(new SleepFunction());
            this.addFunction(new SummonFunction());
            this.addFunction(new FindEntitiesFunction());
            this.addFunction(new FindSpellsFunction());
            this.addFunction(new CollectFunction());
            this.addFunction(new InterceptFunction());
            this.addFunction(new RaycastBlockFunction());
            this.addFunction(new RaycastEntityFunction());
            this.addFunction(new RaycastFunction());
            this.addFunction(new FireFunction());
            this.addFunction(new KillFunction());
            this.addFunction(new MoveFunction());
            this.addFunction(new EvaluateFunction());
            this.addFunction(new CopyStructureFunction());
            this.addFunction(new PasteStructureFunction());
            this.addFunction(new SetYawFunction());
        }

        @Override
        protected final LuaSpell<Spell, Class> createNewLuaInstance(Spell javaInstance) {
            return new LuaSpell<Spell, Class>(this, javaInstance);
        }

        private class_2382 toVec3i(class_243 v) {
            int x = (int)Math.floor(v.field_1352);
            int y = (int)Math.floor(v.field_1351);
            int z = (int)Math.floor(v.field_1350);
            return new class_2382(x, y, z);
        }

        class ExecuteFunction
        extends NamedFunction3 {
            ExecuteFunction() {
            }

            @Override
            public String getName() {
                return "execute";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                String cmdStr = Class.this.getConverters().toJavaNullable(String.class, arg2, 2, "command", this.getName());
                CommandTrace trace = Class.this.getConverters().toJavaNullable(CommandTrace.class, arg3, 3, "trace", this.getName());
                Spell spell = (Spell)self.getDelegate();
                int result = spell.execute(cmdStr, this.getCommandOutput(spell, trace));
                context.getReturnBuffer().setTo(Class.this.getConverters().toLua(result));
            }

            private class_2165 getCommandOutput(Spell spell, final @Nullable CommandTrace trace) {
                final class_2168 origCommandSource = spell.getSpellScope().getCommandSource();
                return new class_2165(){

                    public boolean method_9202() {
                        return true;
                    }

                    public boolean method_9200() {
                        return true;
                    }

                    public boolean method_9201() {
                        return false;
                    }

                    public void method_43496(class_2561 text) {
                        origCommandSource.method_9226(() -> text, false);
                        if (trace != null) {
                            trace.add(text);
                        }
                    }
                };
            }
        }

        class ExecuteSilentFunction
        extends NamedFunction3 {
            ExecuteSilentFunction() {
            }

            @Override
            public String getName() {
                return "executeSilent";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                String cmdStr = Class.this.getConverters().toJavaNullable(String.class, arg2, 2, "command", this.getName());
                CommandTrace trace = Class.this.getConverters().toJavaNullable(CommandTrace.class, arg3, 3, "trace", this.getName());
                Spell spell = (Spell)self.getDelegate();
                int result = spell.execute(cmdStr, this.getCommandOutput(trace));
                context.getReturnBuffer().setTo(Class.this.getConverters().toLua(result));
            }

            private class_2165 getCommandOutput(final @Nullable CommandTrace trace) {
                return new class_2165(){

                    public boolean method_9202() {
                        return true;
                    }

                    public boolean method_9200() {
                        return trace != null;
                    }

                    public boolean method_9201() {
                        return false;
                    }

                    public void method_43496(class_2561 text) {
                        if (trace != null) {
                            trace.add(text);
                        }
                    }
                };
            }
        }

        class SleepFunction
        extends NamedFunction2 {
            SleepFunction() {
            }

            @Override
            public String getName() {
                return "sleep";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                Integer ticks = Class.this.getConverters().toJavaNullable(Integer.class, arg2, 2, "ticks", this.getName());
                try {
                    Spell spell = (Spell)self.getDelegate();
                    this.sleep(context, spell, ticks);
                }
                catch (UnresolvedControlThrowable t) {
                    throw t.resolve((Resumable)this, null);
                }
                this.execute(context);
            }

            @Override
            public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
                this.execute(context);
            }

            private void execute(ExecutionContext context) {
                context.getReturnBuffer().setTo();
            }

            public void sleep(ExecutionContext context, Spell spell, @Nullable Integer ticks) throws UnresolvedControlThrowable {
                LuaScheduler scheduler = spell.getProgram().getScheduler();
                long sleepTrigger = spell.getProgram().getLuaTicksLimit() / 2L;
                if (ticks == null) {
                    if (scheduler.getAllowance() < sleepTrigger) {
                        ticks = 1;
                    } else {
                        return;
                    }
                }
                if (ticks < 0) {
                    throw new IllegalOperationAttemptException("attempt to sleep a negative amount of ticks");
                }
                scheduler.sleep(context, ticks);
            }
        }

        class SummonFunction
        extends NamedFunction3 {
            SummonFunction() {
            }

            @Override
            public String getName() {
                return "summon";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                String entityTypeName = Class.this.getConverters().toJavaNullable(String.class, arg2, 2, "entityTypeName", this.getName());
                Spell spell = (Spell)self.getDelegate();
                class_3218 world = spell.getWorld();
                Table nbtTable = Class.this.getConverters().toJavaNullable(Table.class, arg3, 3, "nbtTable", this.getName());
                nbtTable = nbtTable == null ? context.newTable() : TableUtils.copy(nbtTable, (TableFactory)context);
                nbtTable.rawset((Object)"id", (Object)entityTypeName);
                class_2487 nbt = Class.this.getNbtConverter().toNbtCompound(nbtTable);
                class_243 pos = spell.getPos();
                Object object = nbtTable.rawget((Object)"Pos");
                if (object instanceof Table) {
                    Table t = (Table)object;
                    Object v1 = t.rawget(1L);
                    Object v2 = t.rawget(2L);
                    Object v3 = t.rawget(3L);
                    if (v1 instanceof Number) {
                        Number n1 = (Number)v1;
                        if (v2 instanceof Number) {
                            Number n2 = (Number)v2;
                            if (v3 instanceof Number) {
                                Number n3 = (Number)v3;
                                pos = new class_243(n1.doubleValue(), n2.doubleValue(), n3.doubleValue());
                            }
                        }
                    }
                }
                class_243 initPos = pos;
                class_1297 entity = class_1299.method_17842((class_2487)nbt, (class_1937)world, (class_3730)class_3730.field_16462, e -> {
                    e.method_5808(initPos.field_1352, initPos.field_1351, initPos.field_1350, e.method_36454(), e.method_36455());
                    return e;
                });
                class_3218 serverWorldAcces = world;
                class_1266 difficulty = world.method_8404(entity.method_24515());
                if (entity instanceof class_1308) {
                    class_1308 mobEntity = (class_1308)entity;
                    mobEntity.method_5943((class_5425)serverWorldAcces, difficulty, class_3730.field_16462, null);
                }
                if (!world.method_30736(entity)) {
                    throw new RuntimeException(new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.summon.failed")).create());
                }
                class_2487 nbtOut = new class_2487();
                entity.method_5647(nbtOut);
                Object result = Class.this.getConverters().toLuaNullable(entity);
                context.getReturnBuffer().setTo(result);
            }

            @Override
            public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
                throw new NonsuspendableFunctionException(this.getClass());
            }
        }

        class FindEntitiesFunction
        extends NamedFunction2 {
            FindEntitiesFunction() {
            }

            @Override
            public String getName() {
                return "findEntities";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                String selector = Class.this.getConverters().toJava(String.class, arg2, 2, "selector", this.getName());
                Spell spell = (Spell)self.getDelegate();
                List<? extends class_1297> entities = this.find(spell, selector);
                Object luaResult = Class.this.getConverters().toLuaNullable(entities);
                context.getReturnBuffer().setTo(luaResult);
            }

            @Override
            public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
                throw new NonsuspendableFunctionException(this.getClass());
            }

            public List<? extends class_1297> find(Spell spell, String selector) {
                try {
                    boolean atAllowed = true;
                    class_2303 reader = new class_2303(new StringReader(selector), atAllowed);
                    class_2300 entitySelector = reader.method_9882();
                    class_2168 commandSource = spell.createCommandSource();
                    return entitySelector.method_9816(commandSource);
                }
                catch (CommandSyntaxException e) {
                    throw new LuaRuntimeException((Throwable)e);
                }
            }
        }

        private class FindSpellsFunction
        extends NamedFunction2 {
            private FindSpellsFunction() {
            }

            @Override
            public String getName() {
                return "findSpells";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                Table criteria = Class.this.getConverters().toJavaOptional(Table.class, arg2, 2, "criteria", this.getName()).orElse((Table)new DefaultTable());
                Spell spell = (Spell)self.getDelegate();
                Iterable<Spell> result = this.find(spell, criteria);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLua(result));
            }

            private Iterable<Spell> find(Spell spell, Table criteria) {
                boolean excludeSelf;
                Number minradius;
                Number maxradius;
                Number sid;
                String tag;
                String owner;
                ArrayList<Predicate<Spell>> predicates = new ArrayList<Predicate<Spell>>();
                String name = Class.this.getConverters().toJavaNullable(String.class, criteria.rawget((Object)"name"), "criteria.name");
                if (name != null) {
                    predicates.add(it -> name.equals(it.getName()));
                }
                if ((owner = Class.this.getConverters().toJavaNullable(String.class, criteria.rawget((Object)"owner"), "criteria.owner")) != null) {
                    predicates.add(it -> it.getOwner() != null && owner.equals(spell.getOwner().method_5477().getString()));
                }
                if ((tag = Class.this.getConverters().toJavaNullable(String.class, criteria.rawget((Object)"tag"), "criteria.tag")) != null) {
                    predicates.add(it -> it.getTags().contains(tag));
                }
                if ((sid = Class.this.getConverters().toJavaNullable(Number.class, criteria.rawget((Object)"sid"), "criteria.sid")) != null) {
                    predicates.add(it -> it.getSid() == sid.longValue());
                }
                if ((maxradius = Class.this.getConverters().toJavaNullable(Number.class, criteria.rawget((Object)"maxradius"), "criteria.maxradius")) != null) {
                    double rmaxSq = maxradius.doubleValue() * maxradius.doubleValue();
                    predicates.add(it -> it.getDistanceSq(spell) <= rmaxSq);
                }
                if ((minradius = Class.this.getConverters().toJavaNullable(Number.class, criteria.rawget((Object)"minradius"), "criteria.minradius")) != null) {
                    double rminSq = minradius.doubleValue() * minradius.doubleValue();
                    predicates.add(it -> it.getDistanceSq(spell) >= rminSq);
                }
                if (excludeSelf = Class.this.getConverters().toJavaOptional(Boolean.class, criteria.rawget((Object)"excludeSelf"), "criteria.excludeSelf").orElse(false).booleanValue()) {
                    predicates.add(it -> it != spell);
                }
                return spell.findSpells(predicates);
            }
        }

        class CollectFunction
        extends NamedFunctionAnyArg {
            CollectFunction() {
            }

            @Override
            public String getName() {
                return "collect";
            }

            public void invoke(ExecutionContext context, Object[] args) throws ResolvedControlThrowable {
                ArrayDeque<Object> argList = new ArrayDeque<Object>(Arrays.asList(args));
                Object arg1 = argList.isEmpty() ? null : argList.pop();
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                List<String> eventNames = Class.this.getConverters().toJavaList(String.class, argList.toArray(), this.getName());
                Spell spell = (Spell)self.getDelegate();
                EventQueue eventQueue = spell.createEventQueue(eventNames);
                Object result = Class.this.getConverters().toLua(eventQueue);
                context.getReturnBuffer().setTo(result);
            }

            @Override
            public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
                throw new NonsuspendableFunctionException(this.getClass());
            }
        }

        class InterceptFunction
        extends NamedFunction4 {
            InterceptFunction() {
            }

            @Override
            public String getName() {
                return "intercept";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3, Object arg4) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                Spell spell = (Spell)self.getDelegate();
                List<String> eventNames = Class.this.getConverters().toJavaList(String.class, arg2, 2, "eventNames", this.getName());
                LuaFunction eventHandler = Class.this.getConverters().toJava(LuaFunction.class, arg3, 3, "eventHandler", this.getName());
                Long luaTicksLimit = Class.this.getConverters().toJavaNullable(Long.TYPE, arg4, 4, "luaTicksLimit", this.getName());
                EventInterceptor eventInterceptor = spell.createEventInterceptor(eventNames, eventHandler, luaTicksLimit);
                Object result = Class.this.getConverters().toLua(eventInterceptor);
                context.getReturnBuffer().setTo(result);
            }
        }

        class RaycastBlockFunction
        extends NamedFunction2 {
            RaycastBlockFunction() {
            }

            @Override
            public String getName() {
                return "raycastBlock";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                double maxDistance = Class.this.getConverters().toJava(Double.TYPE, arg2, 2, "maxDistance", this.getName());
                Spell spell = (Spell)self.getDelegate();
                class_3965 result = RaycastUtil.raycastToBlock(spell, maxDistance);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLuaNullable(result));
            }
        }

        class RaycastEntityFunction
        extends NamedFunction3 {
            RaycastEntityFunction() {
            }

            @Override
            public String getName() {
                return "raycastEntity";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                double maxDistance = Class.this.getConverters().toJava(Double.TYPE, arg2, 2, "maxDistance", this.getName());
                boolean excludeSpellOwner = Class.this.getConverters().toJavaOptional(Boolean.TYPE, arg3, 3, "excludeSpellOwner", this.getName()).orElse(false);
                Spell spell = (Spell)self.getDelegate();
                class_3966 result = RaycastUtil.raycastToEntity(spell, maxDistance, excludeSpellOwner);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLuaNullable(result));
            }
        }

        class RaycastFunction
        extends NamedFunction3 {
            RaycastFunction() {
            }

            @Override
            public String getName() {
                return "raycast";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                double maxDistance = Class.this.getConverters().toJava(Double.TYPE, arg2, 2, "maxDistance", this.getName());
                boolean excludeSpellOwner = Class.this.getConverters().toJavaOptional(Boolean.TYPE, arg3, 3, "excludeSpellOwner", this.getName()).orElse(false);
                Spell spell = (Spell)self.getDelegate();
                class_239 result = RaycastUtil.raycast(spell, maxDistance, excludeSpellOwner);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLuaNullable(result));
            }
        }

        class FireFunction
        extends NamedFunction3 {
            FireFunction() {
            }

            @Override
            public String getName() {
                return "fire";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                String name = Class.this.getConverters().toJava(String.class, arg2, 2, "name", this.getName());
                Table data = Class.this.getConverters().toJavaNullable(Table.class, arg3, 3, "data", this.getName());
                Spell spell = (Spell)self.getDelegate();
                boolean proceed = spell.fireEvent(new CustomEvent(name, data));
                context.getReturnBuffer().setTo(Class.this.getConverters().toLua(proceed));
            }
        }

        class KillFunction
        extends NamedFunction1 {
            KillFunction() {
            }

            @Override
            public String getName() {
                return "kill";
            }

            public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                Spell spell = (Spell)self.getDelegate();
                spell.setDead();
                context.getReturnBuffer().setTo();
            }
        }

        class MoveFunction
        extends NamedFunction3 {
            MoveFunction() {
            }

            @Override
            public String getName() {
                return "move";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().toJava(LuaSpell.class, arg1, 1, "self", this.getName());
                String direction = Class.this.getConverters().toJava(String.class, arg2, 2, "direction", this.getName());
                double distance = Class.this.getConverters().toJavaOptional(Double.class, arg3, 3, "distance", this.getName()).orElse(1.0);
                WolDirection dir = WolDirection.byName(direction);
                Spell spell = (Spell)self.getDelegate();
                spell.move(dir, distance);
                context.getReturnBuffer().setTo();
            }
        }

        class EvaluateFunction
        extends NamedFunction2 {
            EvaluateFunction() {
            }

            @Override
            public String getName() {
                return "evaluate";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                boolean hasPlaceholderApi = FabricLoader.getInstance().isModLoaded("placeholder-api");
                if (!hasPlaceholderApi) {
                    throw new UnsupportedOperationException("Placeholder API not found. Please drop placeholder-api-*.jar into mods folder.");
                }
                LuaSpell self = Class.this.getConverters().castTo(LuaSpell.class, arg1, 1, "self", this.getName());
                class_2168 commandSource = ((AbstractLuaClass)((Object)self.getLuaClass())).getCommandSource();
                String text = Class.this.getConverters().toJava(String.class, arg2, 2, "text", this.getName());
                PlaceholderContext ctx = PlaceholderContext.of((class_2168)commandSource);
                class_2561 parsed = Placeholders.parseText((class_2561)class_2561.method_43470((String)text), (PlaceholderContext)ctx);
                String value = parsed.getString();
                context.getReturnBuffer().setTo(Class.this.getConverters().toLuaNullable(value));
            }
        }

        class CopyStructureFunction
        extends NamedFunction4 {
            CopyStructureFunction() {
            }

            @Override
            public String getName() {
                return "copyStructure";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object oppositeCornerArg, Object includeEntitiesArg, Object ignoreArg) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().castTo(LuaSpell.class, selfArg, 1, "self", this.getName());
                class_2382 opposite = Class.this.toVec3i(Class.this.getConverters().toJava(class_243.class, oppositeCornerArg, 2, "oppositeCorner", this.getName()));
                class_2338 pos = ((Spell)self.getDelegate()).getBlockPos();
                int minX = Math.min(pos.method_10263(), opposite.method_10263());
                int minY = Math.min(pos.method_10264(), opposite.method_10264());
                int minZ = Math.min(pos.method_10260(), opposite.method_10260());
                int maxX = Math.max(pos.method_10263(), opposite.method_10263());
                int maxY = Math.max(pos.method_10264(), opposite.method_10264());
                int maxZ = Math.max(pos.method_10260(), opposite.method_10260());
                class_2338 min = new class_2338(minX, minY, minZ);
                int sizeX = maxX - minX + 1;
                int sizeY = maxY - minY + 1;
                int sizeZ = maxZ - minZ + 1;
                class_2338 start = min;
                class_2382 dimensions = new class_2382(sizeX, sizeY, sizeZ);
                boolean includeEntities = Class.this.getConverters().toJavaOptional(Boolean.TYPE, includeEntitiesArg, 3, "includeEntities", this.getName()).orElse(false);
                String ignore = Class.this.getConverters().toJavaNullable(String.class, ignoreArg, 4, "ignoreBlockId", this.getName());
                class_3499 template = new class_3499();
                class_1297 owner = ((Spell)self.getDelegate()).getOwner();
                if (owner instanceof class_1309) {
                    class_1309 author = (class_1309)owner;
                    template.method_15161(author.method_5477().getString());
                }
                class_2248 ignoredBlock = ignore == null ? null : (class_2248)class_7923.field_41175.method_63535(class_2960.method_60654((String)ignore));
                template.method_15174((class_1937)Class.this.getWorld(), start, dimensions, includeEntities, ignoredBlock);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLua(template));
            }
        }

        class PasteStructureFunction
        extends NamedFunction4 {
            PasteStructureFunction() {
            }

            @Override
            public String getName() {
                return "pasteStructure";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object templateArg, Object originOffsetArg, Object ignoreBlockIdsArg) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().castTo(LuaSpell.class, selfArg, 1, "self", this.getName());
                class_3499 template = Class.this.getConverters().toJava(class_3499.class, templateArg, 2, "template", this.getName());
                class_243 originOffset = Class.this.getConverters().toJavaOptional(class_243.class, originOffsetArg, 3, "originOffset", this.getName()).orElse(class_243.field_1353);
                List<String> ignore = Class.this.getConverters().toJavaListNullable(String.class, ignoreBlockIdsArg, 3, "ignoreBlockIds", this.getName());
                class_3218 world = ((Spell)self.getDelegate()).getWorld();
                class_2338 spellPos = class_2338.method_49638((class_2374)((Spell)self.getDelegate()).getPos());
                class_2338 originLocal = class_2338.method_49638((class_2374)originOffset);
                class_2338 originGlobal = spellPos.method_10059((class_2382)originLocal);
                class_3492 placementData = new class_3492();
                placementData.method_15119(originLocal);
                placementData.method_15123(this.toBlockRotation(((Spell)self.getDelegate()).getYaw()));
                if (ignore != null) {
                    List<class_2248> blockIds = ignore.stream().map(it -> (class_2248)class_7923.field_41175.method_63535(class_2960.method_60654((String)it))).toList();
                    placementData.method_16184((class_3491)new class_3793(blockIds));
                }
                class_2338 pivot = originGlobal;
                template.method_15172((class_5425)world, originGlobal, pivot, placementData, class_5819.method_43049((long)0L), 3);
                context.getReturnBuffer().setTo();
            }

            private class_2470 toBlockRotation(float f) {
                int steps = (int)Math.round((double)f / 90.0);
                int index = Math.floorMod(steps, 4);
                return switch (index) {
                    case 0 -> class_2470.field_11467;
                    case 1 -> class_2470.field_11463;
                    case 2 -> class_2470.field_11464;
                    case 3 -> class_2470.field_11465;
                    default -> throw new IllegalStateException("unreachable: " + index);
                };
            }
        }

        class SetYawFunction
        extends NamedFunction2 {
            SetYawFunction() {
            }

            @Override
            public String getName() {
                return "setYaw";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object directionArg) throws ResolvedControlThrowable {
                LuaSpell self = Class.this.getConverters().castTo(LuaSpell.class, selfArg, 1, "self", this.getName());
                String direction = Class.this.getConverters().toJava(String.class, directionArg, 2, "direction", this.getName());
                class_2350 dir = class_2350.method_10168((String)direction);
                if (dir.method_10166() == class_2350.class_2351.field_11052) {
                    return;
                }
                float yaw = dir.method_10144();
                ((Spell)self.getDelegate()).setYaw(yaw);
                context.getReturnBuffer().setTo();
            }
        }
    }
}

