/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.nbt;

import com.google.common.base.Preconditions;
import net.minecraft.class_2495;
import net.sandius.rembulan.Conversions;
import net.sandius.rembulan.Table;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.lua.nbt.NbtMerger;

public class NbtIntArrayMerger
implements NbtMerger<class_2495> {
    private final NbtConverter converter;

    public NbtIntArrayMerger(NbtConverter converter) {
        this.converter = (NbtConverter)Preconditions.checkNotNull((Object)converter, (Object)"converter == null!");
    }

    @Override
    public class_2495 merge(class_2495 nbt, Object data, String key, String path) {
        Table table;
        if (data instanceof Table && NbtConverter.isArray(table = (Table)data)) {
            long len = table.rawlen();
            if (len > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Can't merge arrays with more that Integer.MAX_VALUE elements!");
            }
            int[] arr = new int[(int)len];
            for (int i = 0; i < arr.length; ++i) {
                int newNbtValue;
                Object newLuaValue = table.rawget((long)(i + 1));
                if (newLuaValue == null) continue;
                arr[i] = newNbtValue = Conversions.integerValueOf((Object)newLuaValue).intValue();
            }
            class_2495 result = new class_2495(arr);
            return result;
        }
        throw this.converter.conversionException(path, data, "table");
    }
}

