/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.spell;

import java.nio.file.FileSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.sandius.rembulan.StateContext;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.Variable;
import net.sandius.rembulan.env.RuntimeEnvironment;
import net.sandius.rembulan.env.RuntimeEnvironments;
import net.sandius.rembulan.exec.CallException;
import net.sandius.rembulan.exec.CallPausedException;
import net.sandius.rembulan.exec.Continuation;
import net.sandius.rembulan.impl.DefaultTable;
import net.sandius.rembulan.impl.StateContexts;
import net.sandius.rembulan.lib.BasicLib;
import net.sandius.rembulan.lib.CoroutineLib;
import net.sandius.rembulan.lib.IoLib;
import net.sandius.rembulan.lib.MathLib;
import net.sandius.rembulan.lib.ModuleLib;
import net.sandius.rembulan.lib.StringLib;
import net.sandius.rembulan.lib.TableLib;
import net.sandius.rembulan.lib.Utf8Lib;
import net.sandius.rembulan.load.ChunkLoader;
import net.sandius.rembulan.load.LoaderException;
import net.sandius.rembulan.runtime.LuaFunction;
import net.wizardsoflua.WizardsOfLuaMod;
import net.wizardsoflua.event.SpellFinishCallback;
import net.wizardsoflua.event.SpellTerminatedCallback;
import net.wizardsoflua.extension.spell.api.resource.LuaTypes;
import net.wizardsoflua.lua.Converters;
import net.wizardsoflua.lua.compiler.ExtendedChunkLoader;
import net.wizardsoflua.lua.compiler.PatchedCompilerChunkLoader;
import net.wizardsoflua.lua.module.print.LogRedirector;
import net.wizardsoflua.lua.module.print.PrintRedirector;
import net.wizardsoflua.lua.module.searcher.ClasspathResourceSearcher;
import net.wizardsoflua.lua.module.searcher.LuaFunctionBinaryCache;
import net.wizardsoflua.lua.module.searcher.PatchedChunkLoadPathSearcher;
import net.wizardsoflua.lua.module.types.TypesModule;
import net.wizardsoflua.lua.module.wol.LogTarget;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.lua.scheduling.CallFellAsleepException;
import net.wizardsoflua.lua.scheduling.LuaScheduler;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellException;
import net.wizardsoflua.spell.SpellExceptionFactory;
import net.wizardsoflua.spell.SpellScope;
import net.wizardsoflua.spell.WolRuntimeEnvironment;

public class SpellProgram {
    public static final String ROOT_CLASS_PREFIX = "SpellByteCode";
    private final LuaFunctionBinaryCache luaFunctionCache;
    private final SpellScope spellScope;
    private final StateContext stateContext = StateContexts.newDefaultInstance();
    private final LuaScheduler scheduler = new LuaScheduler(this.stateContext);
    private final ExtendedChunkLoader loader = PatchedCompilerChunkLoader.of("SpellByteCode");
    private final SpellExceptionFactory exceptionFactory = new SpellExceptionFactory();
    private final LinkedHashMap<Object, Object> argsMap;
    private final Table env = this.stateContext.newTable();
    private State state = State.NEW;
    private Continuation continuation;
    private long luaTicksLimit = 50000L;
    private long wakeUpTime;
    private Spell spell;
    private String code;

    public SpellProgram(LuaFunctionBinaryCache luaFunctionCache, SpellScope spellScope, String code, LinkedHashMap<Object, Object> argsMap) {
        this.luaFunctionCache = Objects.requireNonNull(luaFunctionCache, "luaFunctionCache");
        this.spellScope = Objects.requireNonNull(spellScope, "spellScope");
        this.code = code;
        this.argsMap = argsMap;
        this.installSystemLibraries();
        PrintRedirector.installInto(this.env, message -> spellScope.getCommandSource().method_9226(() -> class_2561.method_43470((String)message), false));
        LogRedirector.installInto(this.env, message -> {
            LogTarget logTarget = spellScope.getWolModule().getLog();
            switch (logTarget) {
                case source: {
                    class_2168 commandSource = spellScope.getTopmostCommandSource();
                    commandSource.method_45068((class_2561)class_2561.method_43470((String)message));
                    break;
                }
                case console: {
                    WizardsOfLuaMod.LOGGER.info(message);
                    break;
                }
                case operators: {
                    for (class_3222 serverPlayerEntity : spellScope.getWorld().method_8503().method_3760().method_14571()) {
                        if (!spellScope.getWorld().method_8503().method_3760().method_14569(serverPlayerEntity.method_7334())) continue;
                        serverPlayerEntity.method_64398(class_2561.method_30163((String)message));
                    }
                    spellScope.getWorld().method_8503().method_3739().method_45068((class_2561)class_2561.method_43470((String)message));
                    break;
                }
            }
        });
        this.env.rawset((Object)"WizardsOfLua", this.getConverters().toLua(spellScope.getWolModule()));
        this.installTypesModule();
        spellScope.getTypes().installInto(this.env);
    }

    void setSpell(Spell spell) {
        this.spell = Objects.requireNonNull(spell, "spell");
        Object luaSpell = this.getConverters().toLua(spell);
        this.env.rawset((Object)"spell", luaSpell);
    }

    public Spell getSpell() {
        return this.spell;
    }

    public LuaTypes getTypes() {
        return this.spellScope.getTypes();
    }

    public Converters getConverters() {
        return this.spellScope.getConverters();
    }

    public NbtConverter getNbtConverter() {
        return this.spellScope.getNbtConverter();
    }

    public LuaScheduler getScheduler() {
        return this.scheduler;
    }

    public long getLuaTicksLimit() {
        return this.luaTicksLimit;
    }

    public void setLuaTicksLimit(long luaTicksLimit) {
        this.luaTicksLimit = luaTicksLimit;
    }

    private void installTypesModule() {
        TypesModule typesModule = new TypesModule(this.getTypes(), this.env, DefaultTable.factory());
        Object luaObject = this.getConverters().toLua(typesModule);
        this.env.rawset((Object)"Types", luaObject);
    }

    public String getCode() {
        return this.code;
    }

    public boolean isFinished() {
        return this.state == State.FINISHED || this.state == State.TERMINATED;
    }

    public boolean isTerminated() {
        return this.state == State.TERMINATED;
    }

    void terminate() {
        this.state = State.TERMINATED;
        ((SpellTerminatedCallback)SpellTerminatedCallback.EVENT.invoker()).onSpellTerminated(this.spell);
    }

    void finish() {
        ((SpellFinishCallback)SpellFinishCallback.EVENT.invoker()).onSpellFinish(this.spell);
        this.state = State.FINISHED;
    }

    private void installSystemLibraries() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        BasicLib.installInto((StateContext)this.stateContext, (Table)this.env, null, (ChunkLoader)this.loader);
        ModuleLib.installInto((StateContext)this.stateContext, (Table)this.env, null, null, null);
        ClasspathResourceSearcher.installInto(this.env, this.loader, this.luaFunctionCache, classLoader);
        FileSystem realFileSystem = this.spellScope.getWolServerFileSystem().getDelegate();
        String luaSearchPath = this.spellScope.getDirectories().getLuaSearchPath(realFileSystem);
        PatchedChunkLoadPathSearcher.installInto(this.env, this.loader, this.luaFunctionCache, classLoader, realFileSystem, () -> luaSearchPath);
        CoroutineLib.installInto((StateContext)this.stateContext, (Table)this.env);
        StringLib.installInto((StateContext)this.stateContext, (Table)this.env);
        MathLib.installInto((StateContext)this.stateContext, (Table)this.env);
        TableLib.installInto((StateContext)this.stateContext, (Table)this.env);
        WolRuntimeEnvironment runtimeEnvironment = new WolRuntimeEnvironment(RuntimeEnvironments.system(), this.spellScope.getWolServerFileSystem());
        IoLib.installInto((StateContext)this.stateContext, (Table)this.env, (RuntimeEnvironment)runtimeEnvironment);
        Utf8Lib.installInto((StateContext)this.stateContext, (Table)this.env);
    }

    public void resume() {
        try {
            switch (this.state.ordinal()) {
                case 0: {
                    this.compileAndRun();
                    this.finish();
                    break;
                }
                case 1: {
                    if (this.wakeUpTime > this.spellScope.getWorld().method_8510()) {
                        return;
                    }
                }
                case 2: {
                    this.scheduler.resume(this.luaTicksLimit, this.continuation);
                    this.finish();
                    break;
                }
                case 3: 
                case 4: {
                    return;
                }
            }
        }
        catch (CallFellAsleepException ex) {
            int sleepDuration = ex.getSleepDuration();
            this.wakeUpTime = this.spellScope.getWorld().method_8510() + (long)sleepDuration;
            this.continuation = ex.getContinuation();
            this.state = State.SLEEPING;
        }
        catch (CallPausedException ex) {
            this.continuation = ex.getContinuation();
            this.state = State.PAUSED;
        }
        catch (Exception ex) {
            this.handleException("Error during spell execution", ex);
        }
    }

    private void compileAndRun() throws LoaderException, CallException, CallPausedException, InterruptedException {
        this.addGlobalRequirements();
        Object[] arguments = this.installArgs(this.argsMap);
        LuaFunction commandLineFunc = this.loader.loadTextChunk(new Variable((Object)this.env), "command-line", this.code);
        this.scheduler.call(this.luaTicksLimit, commandLineFunc, arguments);
    }

    private void addGlobalRequirements() throws CallException, InterruptedException {
        LuaFunction requireFunction = Objects.requireNonNull((LuaFunction)this.env.rawget((Object)"require"), "Missing require function!");
        for (String module : Arrays.asList("wol.globals", "wol.Vec3")) {
            this.scheduler.callUnpausable(Long.MAX_VALUE, requireFunction, module);
        }
    }

    private Object[] installArgs(Map<Object, Object> argMap) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (argMap.size() > 0) {
            Table argsTable = DefaultTable.factory().newTable();
            for (Object key : argMap.keySet()) {
                Object value = this.spellScope.getConverters().toLua(argMap.get(key));
                argsTable.rawset(key, value);
                result.add(value);
            }
            this.env.rawset((Object)"args", (Object)argsTable);
        }
        return result.toArray();
    }

    public void handleException(String contextMessage, Throwable t) {
        this.spell.setDead();
        SpellException s = this.exceptionFactory.create(t);
        String message = String.format("%s: %s", contextMessage, s.getMessage());
        WizardsOfLuaMod.LOGGER.error(message, (Throwable)s);
        class_1297 owner = this.spellScope.getOwner();
        class_3218 world = (class_3218)owner.method_37908();
        if (owner != null) {
            class_5250 txt = class_2561.method_43470((String)message).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)).method_10982(Boolean.valueOf(true)));
            owner.method_5671(world).method_45068((class_2561)txt);
        }
    }

    private static enum State {
        NEW,
        SLEEPING,
        PAUSED,
        FINISHED,
        TERMINATED;

    }
}

