/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.spell;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.wizardsoflua.event.EventHandlerType;
import net.wizardsoflua.event.WolEvent;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.VirtualEntity;

public class SpellRegistry {
    private final List<Spell> spells = new CopyOnWriteArrayList<Spell>();

    public void add(Spell spell) {
        this.spells.add(spell);
    }

    public void tick() {
        for (Spell spell : this.spells) {
            spell.tick();
        }
    }

    public void onSpellTermiated(Spell spell) {
        this.spells.remove(spell);
    }

    public boolean forwardEvent(String eventName, WolEvent event, EventHandlerType eventHandlerType) {
        for (Spell spell : this.spells) {
            boolean proceed = spell.onEvent(eventName, event, eventHandlerType);
            if (proceed) continue;
            return false;
        }
        return true;
    }

    public Collection<Spell> getAll() {
        return Collections.unmodifiableCollection(this.spells);
    }

    public Collection<Spell> get(Predicate<Spell> predicate) {
        return Collections.unmodifiableCollection(this.spells.stream().filter(predicate).toList());
    }

    public Iterable<Spell> filter(List<Predicate<Spell>> predicates) {
        Stream<Object> stream = this.spells.stream();
        for (Predicate<Spell> predicate : predicates) {
            stream = stream.filter(predicate);
        }
        return stream.toList();
    }

    public Iterable<String> getActiveSids() {
        return Lists.transform(this.spells, s -> String.valueOf(s.getSid()));
    }

    public Iterable<String> getActiveNames() {
        return Lists.transform(this.spells, VirtualEntity::getName);
    }

    public int breakSpells(Iterable<Spell> spells) {
        int result = 0;
        for (Spell spell : spells) {
            spell.setDead();
            ++result;
        }
        return result;
    }
}

