/*
 * Decompiled with CFR 0.152.
 */
package org.nyt.WhiteNoiseGenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.noise.SimplexOctaveGenerator;

public class WhiteNoiseGenerator
extends JavaPlugin {
    public void onEnable() {
        this.getLogger().info("White Noise Generator loaded!");
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return new NoiseChunkGenerator(this.parseParams(id));
    }

    private ParsedParams parseParams(String id) {
        List<Material> blockPalette = this.getDefaultPalette();
        double scale = 0.02;
        int octaves = 8;
        double noise = 0.5;
        if (id != null && id.startsWith("{")) {
            String[] parts;
            block12: for (String part : parts = id.substring(1, id.length() - 1).split(";")) {
                String[] keyValue = part.split("=");
                if (keyValue.length != 2) {
                    this.getLogger().severe("Invalid parameter format: " + part);
                    continue;
                }
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                switch (key) {
                    case "blocks": {
                        ArrayList<Material> parsedBlocks = new ArrayList<Material>();
                        for (String blockName : value.split(",")) {
                            Material mat = Material.matchMaterial((String)blockName.trim().toUpperCase());
                            if (mat != null) {
                                parsedBlocks.add(mat);
                                continue;
                            }
                            this.getLogger().severe("Unknown block: " + blockName);
                        }
                        if (!parsedBlocks.isEmpty()) {
                            blockPalette = parsedBlocks;
                            this.getLogger().info("Block palette set to: " + String.valueOf(blockPalette));
                            continue block12;
                        }
                        this.getLogger().severe("No valid blocks found, using default palette.");
                        continue block12;
                    }
                    case "scale": {
                        scale = this.parseDouble(value, 0.02, 0.02, 1.0, "scale");
                        continue block12;
                    }
                    case "octaves": {
                        octaves = this.parseInt(value, 8, 1, 16, "octaves");
                        continue block12;
                    }
                    case "noise": {
                        noise = this.parseDouble(value, 0.5, 0.0, 1.0, "noise");
                        continue block12;
                    }
                    default: {
                        this.getLogger().severe("Unknown parameter: " + key);
                    }
                }
            }
        } else {
            this.getLogger().severe("No parameters found, using default values.");
        }
        this.getLogger().info(String.format("Final settings - Blocks: %s, Scale: %.2f, Octaves: %d, Noise: %.2f", blockPalette, scale, octaves, noise));
        return new ParsedParams(blockPalette, scale, octaves, noise);
    }

    private double parseDouble(String value, double defaultValue, double min, double max, String paramName) {
        try {
            double parsed = Double.parseDouble(value);
            if (parsed < min || parsed > max) {
                this.getLogger().severe(String.format("%s out of range (%.2f - %.2f): %.2f. Using default: %.2f", paramName, min, max, parsed, defaultValue));
                return defaultValue;
            }
            return parsed;
        }
        catch (NumberFormatException e) {
            this.getLogger().severe(String.format("Invalid %s value: %s. Using default: %.2f", paramName, value, defaultValue));
            return defaultValue;
        }
    }

    private int parseInt(String value, int defaultValue, int min, int max, String paramName) {
        try {
            int parsed = Integer.parseInt(value);
            if (parsed < min || parsed > max) {
                this.getLogger().severe(String.format("%s out of range (%d - %d): %d. Using default: %d", paramName, min, max, parsed, defaultValue));
                return defaultValue;
            }
            return parsed;
        }
        catch (NumberFormatException e) {
            this.getLogger().severe(String.format("Invalid %s value: %s. Using default: %d", paramName, value, defaultValue));
            return defaultValue;
        }
    }

    private List<Material> getDefaultPalette() {
        return Arrays.asList(Material.ORANGE_CONCRETE, Material.MAGENTA_CONCRETE, Material.LIGHT_BLUE_CONCRETE, Material.YELLOW_CONCRETE, Material.LIME_CONCRETE, Material.PINK_CONCRETE, Material.GRAY_CONCRETE, Material.LIGHT_GRAY_CONCRETE, Material.CYAN_CONCRETE, Material.PURPLE_CONCRETE, Material.BLUE_CONCRETE, Material.GREEN_CONCRETE, Material.RED_CONCRETE);
    }

    public static class NoiseChunkGenerator
    extends ChunkGenerator {
        private final List<Material> blockPalette;
        private final double scale;
        private final int octaves;
        private final double noise;

        public NoiseChunkGenerator(ParsedParams params) {
            this.blockPalette = params.blockPalette;
            this.scale = params.scale;
            this.octaves = params.octaves;
            this.noise = params.noise;
        }

        public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biome) {
            ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
            SimplexOctaveGenerator generator = new SimplexOctaveGenerator(new Random(world.getSeed()), this.octaves);
            generator.setScale(this.scale);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < world.getMaxHeight(); ++y) {
                        double noiseValue = generator.noise((double)(chunkX * 16 + x), (double)y, (double)(chunkZ * 16 + z), this.noise, 0.5);
                        if (!(noiseValue > 0.0)) continue;
                        chunkData.setBlock(x, y, z, this.blockPalette.get(ThreadLocalRandom.current().nextInt(this.blockPalette.size())));
                    }
                }
            }
            return chunkData;
        }
    }

    private static class ParsedParams {
        final List<Material> blockPalette;
        final double scale;
        final int octaves;
        final double noise;

        ParsedParams(List<Material> blockPalette, double scale, int octaves, double noise) {
            this.blockPalette = blockPalette;
            this.scale = scale;
            this.octaves = octaves;
            this.noise = noise;
        }
    }
}

