/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.neoforge.datagen;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.block.HugeLilyPadBlock;
import biomesoplenty.block.properties.QuarterProperty;
import biomesoplenty.init.ModTags;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBedBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class BOPBlockLoot
extends BlockLootSubProvider {
    protected final LootItemCondition.Builder hasShears;
    private static final Set<Item> EXPLOSION_RESISTANT = Set.of();
    private static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    public BOPBlockLoot(HolderLookup.Provider lookup) {
        super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), lookup);
        HolderLookup.RegistryLookup itemLookup = this.registries.lookupOrThrow(Registries.ITEM);
        this.hasShears = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)itemLookup, ModTags.Items.SHEARS));
    }

    protected void generate() {
        HolderLookup.RegistryLookup lookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        HolderLookup.RegistryLookup itemLookup = this.registries.lookupOrThrow(Registries.ITEM);
        this.dropSelf(BOPBlocks.WHITE_SAND);
        this.dropSelf(BOPBlocks.WHITE_SANDSTONE);
        this.dropSelf(BOPBlocks.CUT_WHITE_SANDSTONE);
        this.add(BOPBlocks.CUT_WHITE_SANDSTONE_SLAB, p_251501_ -> this.createSlabItemTable((Block)p_251501_));
        this.dropSelf(BOPBlocks.CHISELED_WHITE_SANDSTONE);
        this.dropSelf(BOPBlocks.SMOOTH_WHITE_SANDSTONE);
        this.dropSelf(BOPBlocks.SMOOTH_WHITE_SANDSTONE_STAIRS);
        this.add(BOPBlocks.SMOOTH_WHITE_SANDSTONE_SLAB, p_249500_ -> this.createSlabItemTable((Block)p_249500_));
        this.add(BOPBlocks.WHITE_SANDSTONE_SLAB, p_249500_ -> this.createSlabItemTable((Block)p_249500_));
        this.dropSelf(BOPBlocks.WHITE_SANDSTONE_STAIRS);
        this.dropSelf(BOPBlocks.WHITE_SANDSTONE_WALL);
        this.dropSelf(BOPBlocks.ORANGE_SAND);
        this.dropSelf(BOPBlocks.ORANGE_SANDSTONE);
        this.dropSelf(BOPBlocks.CUT_ORANGE_SANDSTONE);
        this.add(BOPBlocks.CUT_ORANGE_SANDSTONE_SLAB, p_251501_ -> this.createSlabItemTable((Block)p_251501_));
        this.dropSelf(BOPBlocks.CHISELED_ORANGE_SANDSTONE);
        this.dropSelf(BOPBlocks.SMOOTH_ORANGE_SANDSTONE);
        this.dropSelf(BOPBlocks.SMOOTH_ORANGE_SANDSTONE_STAIRS);
        this.add(BOPBlocks.SMOOTH_ORANGE_SANDSTONE_SLAB, p_249500_ -> this.createSlabItemTable((Block)p_249500_));
        this.add(BOPBlocks.ORANGE_SANDSTONE_SLAB, p_249500_ -> this.createSlabItemTable((Block)p_249500_));
        this.dropSelf(BOPBlocks.ORANGE_SANDSTONE_STAIRS);
        this.dropSelf(BOPBlocks.ORANGE_SANDSTONE_WALL);
        this.add(BOPBlocks.MOSSY_BLACK_SAND, p_249779_ -> this.createSingleItemTableWithSilkTouch((Block)p_249779_, (ItemLike)BOPBlocks.BLACK_SAND));
        this.dropSelf(BOPBlocks.BLACK_SAND);
        this.dropSelf(BOPBlocks.BLACK_SANDSTONE);
        this.dropSelf(BOPBlocks.CUT_BLACK_SANDSTONE);
        this.add(BOPBlocks.CUT_BLACK_SANDSTONE_SLAB, p_251501_ -> this.createSlabItemTable((Block)p_251501_));
        this.dropSelf(BOPBlocks.CHISELED_BLACK_SANDSTONE);
        this.dropSelf(BOPBlocks.SMOOTH_BLACK_SANDSTONE);
        this.dropSelf(BOPBlocks.SMOOTH_BLACK_SANDSTONE_STAIRS);
        this.add(BOPBlocks.SMOOTH_BLACK_SANDSTONE_SLAB, p_249500_ -> this.createSlabItemTable((Block)p_249500_));
        this.add(BOPBlocks.BLACK_SANDSTONE_SLAB, p_249500_ -> this.createSlabItemTable((Block)p_249500_));
        this.dropSelf(BOPBlocks.BLACK_SANDSTONE_STAIRS);
        this.dropSelf(BOPBlocks.BLACK_SANDSTONE_WALL);
        this.dropSelf(BOPBlocks.THERMAL_CALCITE);
        this.dropSelf(BOPBlocks.THERMAL_CALCITE_VENT);
        this.dropSelf(BOPBlocks.DRIED_SALT);
        this.dropSelf(BOPBlocks.FLESH);
        this.dropSelf(BOPBlocks.POROUS_FLESH);
        this.addStrandPlantDropTable(BOPBlocks.FLESH_TENDONS, BOPBlocks.FLESH_TENDONS_STRAND);
        this.add(BOPBlocks.EYEBULB, p_250741_ -> this.createSinglePropConditionTable((Block)p_250741_, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(BOPBlocks.HAIR, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.dropWhenSilkTouch(BOPBlocks.PUS_BUBBLE);
        this.dropSelf(BOPBlocks.BRIMSTONE);
        this.dropSelf(BOPBlocks.BRIMSTONE_BRICKS);
        this.add(BOPBlocks.BRIMSTONE_BRICK_SLAB, p_251501_ -> this.createSlabItemTable((Block)p_251501_));
        this.dropSelf(BOPBlocks.BRIMSTONE_BRICK_STAIRS);
        this.dropSelf(BOPBlocks.BRIMSTONE_BRICK_WALL);
        this.dropSelf(BOPBlocks.CHISELED_BRIMSTONE_BRICKS);
        this.dropWhenSilkTouch(BOPBlocks.BRIMSTONE_FUMAROLE);
        this.dropWhenSilkTouch(BOPBlocks.BRIMSTONE_CLUSTER);
        this.dropWhenSilkTouch(BOPBlocks.BRIMSTONE_BUD);
        this.dropWhenSilkTouch(BOPBlocks.BLACKSTONE_SPINES);
        this.dropWhenSilkTouch(BOPBlocks.BLACKSTONE_BULB);
        this.dropSelf(BOPBlocks.ROSE_QUARTZ_BLOCK);
        this.add(BOPBlocks.ROSE_QUARTZ_CLUSTER, p_252201_ -> this.createSilkTouchDispatchTable((Block)p_252201_, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)BOPItems.ROSE_QUARTZ_CHUNK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)lookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)itemLookup, ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)p_252201_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)BOPItems.ROSE_QUARTZ_CHUNK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
        this.dropWhenSilkTouch(BOPBlocks.SMALL_ROSE_QUARTZ_BUD);
        this.dropWhenSilkTouch(BOPBlocks.MEDIUM_ROSE_QUARTZ_BUD);
        this.dropWhenSilkTouch(BOPBlocks.LARGE_ROSE_QUARTZ_BUD);
        this.dropWhenSilkTouch(BOPBlocks.BARNACLES);
        this.dropWhenSilkTouch(BOPBlocks.WISPJELLY);
        this.add(BOPBlocks.ALGAL_END_STONE, p_249779_ -> this.createSingleItemTableWithSilkTouch((Block)p_249779_, (ItemLike)Blocks.END_STONE));
        this.add(BOPBlocks.UNMAPPED_END_STONE, p_249779_ -> this.createSingleItemTableWithSilkTouch((Block)p_249779_, (ItemLike)Blocks.END_STONE));
        this.add(BOPBlocks.NULL_END_STONE, p_249779_ -> this.createSingleItemTableWithSilkTouch((Block)p_249779_, (ItemLike)Blocks.END_STONE));
        this.dropWhenSilkTouch(BOPBlocks.NULL_BLOCK);
        this.dropWhenSilkTouch(BOPBlocks.NULL_LEAVES);
        this.dropWhenSilkTouch(BOPBlocks.NULL_PLANT);
        this.dropWhenSilkTouch(BOPBlocks.ANOMALY);
        this.dropSelf(BOPBlocks.TOADSTOOL);
        this.add(BOPBlocks.TOADSTOOL_BLOCK, p_248785_ -> this.createMushroomBlockDrop((Block)p_248785_, (ItemLike)BOPBlocks.TOADSTOOL));
        this.dropSelf(BOPBlocks.GLOWSHROOM);
        this.add(BOPBlocks.GLOWSHROOM_BLOCK, p_248785_ -> this.createMushroomBlockDrop((Block)p_248785_, (ItemLike)BOPBlocks.GLOWSHROOM));
        this.dropSelf(BOPBlocks.GLOWING_MOSS_BLOCK);
        this.dropSelf(BOPBlocks.GLOWING_MOSS_CARPET);
        this.addStrandPlantDropTable(BOPBlocks.GLOWWORM_SILK, BOPBlocks.GLOWWORM_SILK_STRAND);
        this.dropWhenSilkTouch(BOPBlocks.SPIDER_EGG);
        this.addStrandPlantDropTable(BOPBlocks.HANGING_COBWEB, BOPBlocks.HANGING_COBWEB_STRAND);
        this.add(BOPBlocks.WEBBING, p_249543_ -> this.createMultifaceBlockDrops((Block)p_249543_, this.hasShears));
        this.dropSelf(BOPBlocks.WHITE_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.LIGHT_GRAY_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.GRAY_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.BLACK_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.BROWN_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.RED_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.ORANGE_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.YELLOW_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.LIME_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.GREEN_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.CYAN_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.LIGHT_BLUE_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.BLUE_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.PURPLE_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.MAGENTA_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.PINK_FLOWER_PETAL_BLOCK);
        this.dropSelf(BOPBlocks.FLOWER_STEM);
        this.add(BOPBlocks.ORIGIN_GRASS_BLOCK, p_249779_ -> this.createSingleItemTableWithSilkTouch((Block)p_249779_, (ItemLike)Blocks.DIRT));
        this.dropSelf(BOPBlocks.FLOWERING_OAK_SAPLING);
        this.add(BOPBlocks.FLOWERING_OAK_LEAVES, p_280934_ -> this.createOakLeavesDrops((Block)p_280934_, BOPBlocks.FLOWERING_OAK_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.CYPRESS_SAPLING);
        this.add(BOPBlocks.CYPRESS_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.CYPRESS_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.SNOWBLOSSOM_SAPLING);
        this.add(BOPBlocks.SNOWBLOSSOM_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.SNOWBLOSSOM_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.ORIGIN_OAK_SAPLING);
        this.add(BOPBlocks.ORIGIN_OAK_LEAVES, p_280940_ -> this.createOakLeavesDrops((Block)p_280940_, BOPBlocks.ORIGIN_OAK_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.ORIGIN_OAK_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_ORIGIN_OAK_LOG);
        this.dropSelf(BOPBlocks.ORIGIN_OAK_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_ORIGIN_OAK_WOOD);
        this.dropSelf(BOPBlocks.ORIGIN_OAK_PLANKS);
        this.add(BOPBlocks.ORIGIN_OAK_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.ORIGIN_OAK_STAIRS);
        this.dropSelf(BOPBlocks.ORIGIN_OAK_FENCE);
        this.dropSelf(BOPBlocks.ORIGIN_OAK_FENCE_GATE);
        this.add(BOPBlocks.ORIGIN_OAK_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.ORIGIN_OAK_TRAPDOOR);
        this.dropSelf(BOPBlocks.ORIGIN_OAK_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.ORIGIN_OAK_BUTTON);
        this.dropSelf(BOPBlocks.ORIGIN_OAK_SIGN);
        this.dropSelf(BOPBlocks.ORIGIN_OAK_HANGING_SIGN);
        this.dropSelf(BOPBlocks.FIR_SAPLING);
        this.add(BOPBlocks.FIR_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.FIR_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.FIR_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_FIR_LOG);
        this.dropSelf(BOPBlocks.FIR_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_FIR_WOOD);
        this.dropSelf(BOPBlocks.FIR_PLANKS);
        this.add(BOPBlocks.FIR_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.FIR_STAIRS);
        this.dropSelf(BOPBlocks.FIR_FENCE);
        this.dropSelf(BOPBlocks.FIR_FENCE_GATE);
        this.add(BOPBlocks.FIR_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.FIR_TRAPDOOR);
        this.dropSelf(BOPBlocks.FIR_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.FIR_BUTTON);
        this.dropSelf(BOPBlocks.FIR_SIGN);
        this.dropSelf(BOPBlocks.FIR_HANGING_SIGN);
        this.dropSelf(BOPBlocks.PINE_SAPLING);
        this.add(BOPBlocks.PINE_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.PINE_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.PINE_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_PINE_LOG);
        this.dropSelf(BOPBlocks.PINE_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_PINE_WOOD);
        this.dropSelf(BOPBlocks.PINE_PLANKS);
        this.add(BOPBlocks.PINE_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.PINE_STAIRS);
        this.dropSelf(BOPBlocks.PINE_FENCE);
        this.dropSelf(BOPBlocks.PINE_FENCE_GATE);
        this.add(BOPBlocks.PINE_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.PINE_TRAPDOOR);
        this.dropSelf(BOPBlocks.PINE_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.PINE_BUTTON);
        this.dropSelf(BOPBlocks.PINE_SIGN);
        this.dropSelf(BOPBlocks.PINE_HANGING_SIGN);
        this.dropSelf(BOPBlocks.RED_MAPLE_SAPLING);
        this.add(BOPBlocks.RED_MAPLE_LEAF_LITTER, this.createSegmentedBlockDrops(BOPBlocks.RED_MAPLE_LEAF_LITTER));
        this.add(BOPBlocks.RED_MAPLE_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.RED_MAPLE_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.ORANGE_MAPLE_SAPLING);
        this.add(BOPBlocks.ORANGE_MAPLE_LEAF_LITTER, this.createSegmentedBlockDrops(BOPBlocks.ORANGE_MAPLE_LEAF_LITTER));
        this.add(BOPBlocks.ORANGE_MAPLE_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.ORANGE_MAPLE_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.YELLOW_MAPLE_SAPLING);
        this.add(BOPBlocks.YELLOW_MAPLE_LEAF_LITTER, this.createSegmentedBlockDrops(BOPBlocks.YELLOW_MAPLE_LEAF_LITTER));
        this.add(BOPBlocks.YELLOW_MAPLE_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.YELLOW_MAPLE_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.MAPLE_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_MAPLE_LOG);
        this.dropSelf(BOPBlocks.MAPLE_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_MAPLE_WOOD);
        this.dropSelf(BOPBlocks.MAPLE_PLANKS);
        this.add(BOPBlocks.MAPLE_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.MAPLE_STAIRS);
        this.dropSelf(BOPBlocks.MAPLE_FENCE);
        this.dropSelf(BOPBlocks.MAPLE_FENCE_GATE);
        this.add(BOPBlocks.MAPLE_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.MAPLE_TRAPDOOR);
        this.dropSelf(BOPBlocks.MAPLE_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.MAPLE_BUTTON);
        this.dropSelf(BOPBlocks.MAPLE_SIGN);
        this.dropSelf(BOPBlocks.MAPLE_HANGING_SIGN);
        this.dropSelf(BOPBlocks.REDWOOD_SAPLING);
        this.add(BOPBlocks.REDWOOD_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.REDWOOD_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.REDWOOD_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_REDWOOD_LOG);
        this.dropSelf(BOPBlocks.REDWOOD_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_REDWOOD_WOOD);
        this.dropSelf(BOPBlocks.REDWOOD_PLANKS);
        this.add(BOPBlocks.REDWOOD_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.REDWOOD_STAIRS);
        this.dropSelf(BOPBlocks.REDWOOD_FENCE);
        this.dropSelf(BOPBlocks.REDWOOD_FENCE_GATE);
        this.add(BOPBlocks.REDWOOD_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.REDWOOD_TRAPDOOR);
        this.dropSelf(BOPBlocks.REDWOOD_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.REDWOOD_BUTTON);
        this.dropSelf(BOPBlocks.REDWOOD_SIGN);
        this.dropSelf(BOPBlocks.REDWOOD_HANGING_SIGN);
        this.dropSelf(BOPBlocks.MAHOGANY_SAPLING);
        this.add(BOPBlocks.MAHOGANY_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.MAHOGANY_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.MAHOGANY_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_MAHOGANY_LOG);
        this.dropSelf(BOPBlocks.MAHOGANY_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_MAHOGANY_WOOD);
        this.dropSelf(BOPBlocks.MAHOGANY_PLANKS);
        this.add(BOPBlocks.MAHOGANY_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.MAHOGANY_STAIRS);
        this.dropSelf(BOPBlocks.MAHOGANY_FENCE);
        this.dropSelf(BOPBlocks.MAHOGANY_FENCE_GATE);
        this.add(BOPBlocks.MAHOGANY_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.MAHOGANY_TRAPDOOR);
        this.dropSelf(BOPBlocks.MAHOGANY_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.MAHOGANY_BUTTON);
        this.dropSelf(BOPBlocks.MAHOGANY_SIGN);
        this.dropSelf(BOPBlocks.MAHOGANY_HANGING_SIGN);
        this.dropSelf(BOPBlocks.JACARANDA_SAPLING);
        this.add(BOPBlocks.JACARANDA_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.JACARANDA_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.JACARANDA_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_JACARANDA_LOG);
        this.dropSelf(BOPBlocks.JACARANDA_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_JACARANDA_WOOD);
        this.dropSelf(BOPBlocks.JACARANDA_PLANKS);
        this.add(BOPBlocks.JACARANDA_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.JACARANDA_STAIRS);
        this.dropSelf(BOPBlocks.JACARANDA_FENCE);
        this.dropSelf(BOPBlocks.JACARANDA_FENCE_GATE);
        this.add(BOPBlocks.JACARANDA_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.JACARANDA_TRAPDOOR);
        this.dropSelf(BOPBlocks.JACARANDA_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.JACARANDA_BUTTON);
        this.dropSelf(BOPBlocks.JACARANDA_SIGN);
        this.dropSelf(BOPBlocks.JACARANDA_HANGING_SIGN);
        this.dropSelf(BOPBlocks.PALM_SAPLING);
        this.add(BOPBlocks.PALM_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.PALM_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.PALM_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_PALM_LOG);
        this.dropSelf(BOPBlocks.PALM_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_PALM_WOOD);
        this.dropSelf(BOPBlocks.PALM_PLANKS);
        this.add(BOPBlocks.PALM_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.PALM_STAIRS);
        this.dropSelf(BOPBlocks.PALM_FENCE);
        this.dropSelf(BOPBlocks.PALM_FENCE_GATE);
        this.add(BOPBlocks.PALM_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.PALM_TRAPDOOR);
        this.dropSelf(BOPBlocks.PALM_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.PALM_BUTTON);
        this.dropSelf(BOPBlocks.PALM_SIGN);
        this.dropSelf(BOPBlocks.PALM_HANGING_SIGN);
        this.dropSelf(BOPBlocks.WILLOW_SAPLING);
        this.add(BOPBlocks.WILLOW_VINE, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.addStrandPlantDropTable(BOPBlocks.SPANISH_MOSS, BOPBlocks.SPANISH_MOSS_PLANT);
        this.add(BOPBlocks.WILLOW_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.WILLOW_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.WILLOW_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_WILLOW_LOG);
        this.dropSelf(BOPBlocks.WILLOW_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_WILLOW_WOOD);
        this.dropSelf(BOPBlocks.WILLOW_PLANKS);
        this.add(BOPBlocks.WILLOW_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.WILLOW_STAIRS);
        this.dropSelf(BOPBlocks.WILLOW_FENCE);
        this.dropSelf(BOPBlocks.WILLOW_FENCE_GATE);
        this.add(BOPBlocks.WILLOW_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.WILLOW_TRAPDOOR);
        this.dropSelf(BOPBlocks.WILLOW_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.WILLOW_BUTTON);
        this.dropSelf(BOPBlocks.WILLOW_SIGN);
        this.dropSelf(BOPBlocks.WILLOW_HANGING_SIGN);
        this.dropSelf(BOPBlocks.DEAD_SAPLING);
        this.add(BOPBlocks.DEAD_BRANCH, p_249226_ -> this.createShearsDispatchTable((Block)p_249226_, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)p_249226_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)))))));
        this.add(BOPBlocks.DEAD_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.DEAD_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.DEAD_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_DEAD_LOG);
        this.dropSelf(BOPBlocks.DEAD_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_DEAD_WOOD);
        this.dropSelf(BOPBlocks.DEAD_PLANKS);
        this.add(BOPBlocks.DEAD_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.DEAD_STAIRS);
        this.dropSelf(BOPBlocks.DEAD_FENCE);
        this.dropSelf(BOPBlocks.DEAD_FENCE_GATE);
        this.add(BOPBlocks.DEAD_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.DEAD_TRAPDOOR);
        this.dropSelf(BOPBlocks.DEAD_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.DEAD_BUTTON);
        this.dropSelf(BOPBlocks.DEAD_SIGN);
        this.dropSelf(BOPBlocks.DEAD_HANGING_SIGN);
        this.dropSelf(BOPBlocks.MAGIC_SAPLING);
        this.add(BOPBlocks.MAGIC_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.MAGIC_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.MAGIC_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_MAGIC_LOG);
        this.dropSelf(BOPBlocks.MAGIC_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_MAGIC_WOOD);
        this.dropSelf(BOPBlocks.MAGIC_PLANKS);
        this.add(BOPBlocks.MAGIC_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.MAGIC_STAIRS);
        this.dropSelf(BOPBlocks.MAGIC_FENCE);
        this.dropSelf(BOPBlocks.MAGIC_FENCE_GATE);
        this.add(BOPBlocks.MAGIC_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.MAGIC_TRAPDOOR);
        this.dropSelf(BOPBlocks.MAGIC_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.MAGIC_BUTTON);
        this.dropSelf(BOPBlocks.MAGIC_SIGN);
        this.dropSelf(BOPBlocks.MAGIC_HANGING_SIGN);
        this.dropSelf(BOPBlocks.UMBRAN_SAPLING);
        this.add(BOPBlocks.UMBRAN_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.UMBRAN_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.UMBRAN_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_UMBRAN_LOG);
        this.dropSelf(BOPBlocks.UMBRAN_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_UMBRAN_WOOD);
        this.dropSelf(BOPBlocks.UMBRAN_PLANKS);
        this.add(BOPBlocks.UMBRAN_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.UMBRAN_STAIRS);
        this.dropSelf(BOPBlocks.UMBRAN_FENCE);
        this.dropSelf(BOPBlocks.UMBRAN_FENCE_GATE);
        this.add(BOPBlocks.UMBRAN_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.UMBRAN_TRAPDOOR);
        this.dropSelf(BOPBlocks.UMBRAN_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.UMBRAN_BUTTON);
        this.dropSelf(BOPBlocks.UMBRAN_SIGN);
        this.dropSelf(BOPBlocks.UMBRAN_HANGING_SIGN);
        this.dropSelf(BOPBlocks.HELLBARK_SAPLING);
        this.add(BOPBlocks.HELLBARK_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.HELLBARK_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.HELLBARK_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_HELLBARK_LOG);
        this.dropSelf(BOPBlocks.HELLBARK_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_HELLBARK_WOOD);
        this.dropSelf(BOPBlocks.HELLBARK_PLANKS);
        this.add(BOPBlocks.HELLBARK_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.HELLBARK_STAIRS);
        this.dropSelf(BOPBlocks.HELLBARK_FENCE);
        this.dropSelf(BOPBlocks.HELLBARK_FENCE_GATE);
        this.add(BOPBlocks.HELLBARK_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.HELLBARK_TRAPDOOR);
        this.dropSelf(BOPBlocks.HELLBARK_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.HELLBARK_BUTTON);
        this.dropSelf(BOPBlocks.HELLBARK_SIGN);
        this.dropSelf(BOPBlocks.HELLBARK_HANGING_SIGN);
        this.dropSelf(BOPBlocks.EMPYREAL_SAPLING);
        this.add(BOPBlocks.EMPYREAL_LEAVES, p_280940_ -> this.createLeavesDrops((Block)p_280940_, BOPBlocks.EMPYREAL_SAPLING, NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(BOPBlocks.EMPYREAL_LOG);
        this.dropSelf(BOPBlocks.STRIPPED_EMPYREAL_LOG);
        this.dropSelf(BOPBlocks.EMPYREAL_WOOD);
        this.dropSelf(BOPBlocks.STRIPPED_EMPYREAL_WOOD);
        this.dropSelf(BOPBlocks.EMPYREAL_PLANKS);
        this.add(BOPBlocks.EMPYREAL_SLAB, p_251629_ -> this.createSlabItemTable((Block)p_251629_));
        this.dropSelf(BOPBlocks.EMPYREAL_STAIRS);
        this.dropSelf(BOPBlocks.EMPYREAL_FENCE);
        this.dropSelf(BOPBlocks.EMPYREAL_FENCE_GATE);
        this.add(BOPBlocks.EMPYREAL_DOOR, p_272365_ -> this.createDoorTable((Block)p_272365_));
        this.dropSelf(BOPBlocks.EMPYREAL_TRAPDOOR);
        this.dropSelf(BOPBlocks.EMPYREAL_PRESSURE_PLATE);
        this.dropSelf(BOPBlocks.EMPYREAL_BUTTON);
        this.dropSelf(BOPBlocks.EMPYREAL_SIGN);
        this.dropSelf(BOPBlocks.EMPYREAL_HANGING_SIGN);
        this.add(BOPBlocks.FLOWER_BUD, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.dropSelf(BOPBlocks.ORIGIN_DANDELION);
        this.dropSelf(BOPBlocks.ORIGIN_ROSE);
        this.dropSelf(BOPBlocks.MARIGOLD);
        this.dropSelf(BOPBlocks.VIOLET);
        this.dropSelf(BOPBlocks.LAVENDER);
        this.add(BOPBlocks.TALL_LAVENDER, p_250918_ -> this.createSinglePropConditionTable((Block)p_250918_, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(BOPBlocks.WHITE_LAVENDER);
        this.add(BOPBlocks.TALL_WHITE_LAVENDER, p_250918_ -> this.createSinglePropConditionTable((Block)p_250918_, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(BOPBlocks.BLUE_HYDRANGEA, p_250918_ -> this.createSinglePropConditionTable((Block)p_250918_, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(BOPBlocks.GOLDENROD, p_250918_ -> this.createSinglePropConditionTable((Block)p_250918_, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(BOPBlocks.ORANGE_COSMOS);
        this.dropSelf(BOPBlocks.PINK_DAFFODIL);
        this.dropSelf(BOPBlocks.PINK_HIBISCUS);
        this.add(BOPBlocks.PURPLE_WILDFLOWERS, this.createSegmentedBlockDrops(BOPBlocks.PURPLE_WILDFLOWERS));
        this.add(BOPBlocks.WHITE_PETALS, this.createSegmentedBlockDrops(BOPBlocks.WHITE_PETALS));
        this.add(BOPBlocks.ICY_IRIS, p_250918_ -> this.createSinglePropConditionTable((Block)p_250918_, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(BOPBlocks.GLOWFLOWER);
        this.dropSelf(BOPBlocks.WILTED_LILY);
        this.dropSelf(BOPBlocks.BURNING_BLOSSOM);
        this.dropSelf(BOPBlocks.ENDBLOOM);
        this.add(BOPBlocks.SPROUT, p_249038_ -> this.createGrassDrops((Block)p_249038_));
        this.addStrandPlantDropTable(BOPBlocks.HIGH_GRASS, BOPBlocks.HIGH_GRASS_PLANT);
        this.add(BOPBlocks.CLOVER, this.createCloverDrops(BOPBlocks.CLOVER));
        this.add(BOPBlocks.HUGE_CLOVER_PETAL, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.add(BOPBlocks.HUGE_LILY_PAD, p_250918_ -> this.createSinglePropConditionTable((Block)p_250918_, (Property)HugeLilyPadBlock.QUARTER, (Comparable)((Object)QuarterProperty.SOUTH_WEST)));
        this.dropSelf(BOPBlocks.WATERLILY);
        this.add(BOPBlocks.DUNE_GRASS, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.add(BOPBlocks.DESERT_GRASS, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.add(BOPBlocks.DEAD_GRASS, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.add(BOPBlocks.TUNDRA_SHRUB, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.add(BOPBlocks.ENDERPHYTE, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.addStrandPlantDropTable(BOPBlocks.LUMALOOP, BOPBlocks.LUMALOOP_PLANT);
        this.add(BOPBlocks.BARLEY, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.add(BOPBlocks.SEA_OATS, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.add(BOPBlocks.CATTAIL, p_250918_ -> this.createSinglePropConditionTable((Block)p_250918_, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(BOPBlocks.REED, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.add(BOPBlocks.WATERGRASS, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.dropSelf(BOPBlocks.TINY_CACTUS);
        this.dropSelf(BOPBlocks.BRAMBLE);
        this.add(BOPBlocks.BRAMBLE_LEAVES, p_251652_ -> this.createShearsOnlyDrop((ItemLike)p_251652_));
        this.dropPottedContents(BOPBlocks.POTTED_FLOWERING_OAK_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_CYPRESS_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_SNOWBLOSSOM_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_ORIGIN_OAK_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_FIR_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_PINE_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_RED_MAPLE_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_ORANGE_MAPLE_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_YELLOW_MAPLE_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_REDWOOD_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_MAHOGANY_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_JACARANDA_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_PALM_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_WILLOW_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_DEAD_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_MAGIC_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_UMBRAN_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_HELLBARK_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_EMPYREAL_SAPLING);
        this.dropPottedContents(BOPBlocks.POTTED_FLOWER_BUD);
        this.dropPottedContents(BOPBlocks.POTTED_ORIGIN_DANDELION);
        this.dropPottedContents(BOPBlocks.POTTED_ORIGIN_ROSE);
        this.dropPottedContents(BOPBlocks.POTTED_MARIGOLD);
        this.dropPottedContents(BOPBlocks.POTTED_VIOLET);
        this.dropPottedContents(BOPBlocks.POTTED_LAVENDER);
        this.dropPottedContents(BOPBlocks.POTTED_WHITE_LAVENDER);
        this.dropPottedContents(BOPBlocks.POTTED_ORANGE_COSMOS);
        this.dropPottedContents(BOPBlocks.POTTED_PINK_DAFFODIL);
        this.dropPottedContents(BOPBlocks.POTTED_PINK_HIBISCUS);
        this.dropPottedContents(BOPBlocks.POTTED_GLOWFLOWER);
        this.dropPottedContents(BOPBlocks.POTTED_WILTED_LILY);
        this.dropPottedContents(BOPBlocks.POTTED_BURNING_BLOSSOM);
        this.dropPottedContents(BOPBlocks.POTTED_ENDBLOOM);
        this.dropPottedContents(BOPBlocks.POTTED_SPROUT);
        this.dropPottedContents(BOPBlocks.POTTED_TINY_CACTUS);
        this.dropPottedContents(BOPBlocks.POTTED_TOADSTOOL);
        this.dropPottedContents(BOPBlocks.POTTED_GLOWSHROOM);
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals("biomesoplenty")).map(Map.Entry::getValue).toList();
    }

    protected LootTable.Builder createGrassDrops(Block p_252139_) {
        HolderLookup.RegistryLookup lookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createShearsDispatchTable(p_252139_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)p_252139_, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS).when(LootItemRandomChanceCondition.randomChance((float)0.125f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)lookup.getOrThrow(Enchantments.FORTUNE), (int)2))));
    }

    protected LootTable.Builder createCloverDrops(Block p_273240_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.hasShears).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)p_273240_, LootItem.lootTableItem((ItemLike)p_273240_).apply(IntStream.rangeClosed(1, 4).boxed().toList(), p_272348_ -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)p_272348_.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_273240_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)FlowerBedBlock.AMOUNT, p_272348_.intValue())))))));
    }

    protected void addStrandPlantDropTable(Block p_252269_, Block p_250696_) {
        LootTable.Builder loottable$builder = this.createShearsOnlyDrop((ItemLike)p_252269_);
        this.add(p_252269_, loottable$builder);
        this.add(p_250696_, loottable$builder);
    }

    protected LootTable.Builder createOakLeavesDrops(Block p_249535_, Block p_251505_, float ... p_250753_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createLeavesDrops(p_249535_, p_251505_, p_250753_).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)p_249535_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.APPLE))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    protected LootTable.Builder createShearsDispatchTable(Block p_252195_, LootPoolEntryContainer.Builder<?> p_250102_) {
        return BOPBlockLoot.createSelfDropDispatchTable((Block)p_252195_, (LootItemCondition.Builder)this.hasShears, p_250102_);
    }

    protected LootTable.Builder createLeavesDrops(Block p_250088_, Block p_250731_, float ... p_248949_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(p_250088_, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)p_250088_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)p_250731_))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])p_248949_))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)p_250088_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES))));
    }

    protected LootTable.Builder createSilkTouchOrShearsDispatchTable(Block p_250539_, LootPoolEntryContainer.Builder<?> p_251459_) {
        return BOPBlockLoot.createSelfDropDispatchTable((Block)p_250539_, (LootItemCondition.Builder)this.hasShearsOrSilkTouch(), p_251459_);
    }

    private LootItemCondition.Builder doesNotHaveShearsOrSilkTouch() {
        return this.hasShearsOrSilkTouch().invert();
    }

    private LootItemCondition.Builder hasShearsOrSilkTouch() {
        return this.hasShears.or(this.hasSilkTouch());
    }
}

