/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WebbingFeature
extends Feature<NoneFeatureConfiguration> {
    public WebbingFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel worldIn = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos pos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        int i = 0;
        int j = rand.nextInt(6) + 2;
        for (int k = pos.getX() - j; k <= pos.getX() + j; ++k) {
            block1: for (int l = pos.getZ() - j; l <= pos.getZ() + j; ++l) {
                int j1;
                int i1 = k - pos.getX();
                if (i1 * i1 + (j1 = l - pos.getZ()) * j1 > j * j) continue;
                for (int k1 = pos.getY() - j; k1 <= pos.getY() + j; ++k1) {
                    BlockPos blockpos = new BlockPos(k, k1, l);
                    BlockState blockstate = worldIn.getBlockState(blockpos);
                    BlockState webbingstate = BOPBlocks.WEBBING.defaultBlockState();
                    int faces = 0;
                    for (Direction direction : Direction.values()) {
                        BlockState blockstate1 = worldIn.getBlockState(blockpos.relative(direction));
                        if (blockstate1 != Blocks.STONE.defaultBlockState() && blockstate1 != Blocks.ANDESITE.defaultBlockState() && blockstate1 != Blocks.DIORITE.defaultBlockState() && blockstate1 != Blocks.GRANITE.defaultBlockState() && blockstate1 != Blocks.DRIPSTONE_BLOCK.defaultBlockState() && blockstate1 != Blocks.CALCITE.defaultBlockState() && blockstate1 != Blocks.TUFF.defaultBlockState() && blockstate1 != Blocks.DEEPSLATE.defaultBlockState()) continue;
                        webbingstate = (BlockState)webbingstate.setValue((Property)MultifaceBlock.getFaceProperty((Direction)direction), (Comparable)Boolean.valueOf(true));
                        ++faces;
                    }
                    if (!blockstate.isAir() || faces <= 0) continue;
                    worldIn.setBlock(blockpos, webbingstate, 2);
                    ++i;
                    continue block1;
                }
            }
        }
        return i > 0;
    }
}

