/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.biome;

import biomesoplenty.api.sound.BOPSounds;
import biomesoplenty.biome.BOPOverworldBiomes;
import biomesoplenty.worldgen.placement.BOPNetherPlacements;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.NetherPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.attribute.AmbientAdditionsSettings;
import net.minecraft.world.attribute.AmbientMoodSettings;
import net.minecraft.world.attribute.AmbientParticle;
import net.minecraft.world.attribute.AmbientSounds;
import net.minecraft.world.attribute.BackgroundMusic;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class BOPNetherBiomes {
    private static void addFeature(BiomeGenerationSettings.Builder builder, GenerationStep.Decoration step, ResourceKey<PlacedFeature> feature) {
        builder.addFeature(step, feature);
    }

    public static Biome crystallineChasm(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.CREATURE, 60, new MobSpawnSettings.SpawnerData(EntityType.STRIDER, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        biomeBuilder.addCarver(Carvers.NETHER_CAVE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.SPRING_OPEN);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.GLOWSTONE_EXTRA);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.GLOWSTONE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.BROWN_MUSHROOM_NETHER);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.RED_MUSHROOM_NETHER);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)OrePlacements.ORE_MAGMA);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.SPRING_CLOSED);
        BiomeDefaultFeatures.addNetherDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.LOCAL_MODIFICATIONS, BOPNetherPlacements.LARGE_ROSE_QUARTZ);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.SMALL_CRYSTAL);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).setAttribute(EnvironmentAttributes.SKY_COLOR, (Object)BOPOverworldBiomes.calculateSkyColor(2.0f)).setAttribute(EnvironmentAttributes.WATER_FOG_COLOR, (Object)329011).setAttribute(EnvironmentAttributes.FOG_COLOR, (Object)5832748).setAttribute(EnvironmentAttributes.AMBIENT_SOUNDS, (Object)new AmbientSounds(Optional.of(SoundEvents.AMBIENT_CRIMSON_FOREST_LOOP), Optional.of(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 6000, 8, 2.0)), Collections.emptyList())).setAttribute(EnvironmentAttributes.AMBIENT_PARTICLES, (Object)AmbientParticle.of((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (float)8.925E-4f)).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, (Object)new BackgroundMusic(BOPSounds.MUSIC_BIOME_CRYSTALLINE_CHASM)).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome eruptingInferno(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.MONSTER, 50, new MobSpawnSettings.SpawnerData(EntityType.GHAST, 4, 4));
        spawnBuilder.addSpawn(MobCategory.MONSTER, 2, new MobSpawnSettings.SpawnerData(EntityType.MAGMA_CUBE, 4, 4));
        spawnBuilder.addSpawn(MobCategory.MONSTER, 60, new MobSpawnSettings.SpawnerData(EntityType.ZOMBIFIED_PIGLIN, 4, 4));
        spawnBuilder.addSpawn(MobCategory.MONSTER, 15, new MobSpawnSettings.SpawnerData(EntityType.PIGLIN, 4, 4));
        spawnBuilder.addSpawn(MobCategory.MONSTER, 1, new MobSpawnSettings.SpawnerData(EntityType.ENDERMAN, 4, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, 100, new MobSpawnSettings.SpawnerData(EntityType.STRIDER, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        biomeBuilder.addCarver(Carvers.NETHER_CAVE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.SPRING_OPEN);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.PATCH_FIRE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.PATCH_SOUL_FIRE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.GLOWSTONE_EXTRA);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.GLOWSTONE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)OrePlacements.ORE_MAGMA);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.SPRING_CLOSED);
        BiomeDefaultFeatures.addNetherDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.INFERNO_LAVA_LAKE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.INFERNO_LAVA_SPRING);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.INFERNO_SPLATTER);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.LARGE_FUMAROLE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.SMALL_FUMAROLE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.BRIMSTONE_BUD);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.BRIMSTONE_CLUSTER);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).setAttribute(EnvironmentAttributes.SKY_COLOR, (Object)BOPOverworldBiomes.calculateSkyColor(2.0f)).setAttribute(EnvironmentAttributes.WATER_FOG_COLOR, (Object)329011).setAttribute(EnvironmentAttributes.FOG_COLOR, (Object)5188371).setAttribute(EnvironmentAttributes.AMBIENT_SOUNDS, (Object)new AmbientSounds(Optional.of(SoundEvents.AMBIENT_BASALT_DELTAS_LOOP), Optional.of(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 6000, 8, 2.0)), List.of(new AmbientAdditionsSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_ADDITIONS, 0.0111)))).setAttribute(EnvironmentAttributes.AMBIENT_PARTICLES, (Object)AmbientParticle.of((ParticleOptions)ParticleTypes.SMOKE, (float)2.3065104E-4f)).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, (Object)new BackgroundMusic(BOPSounds.MUSIC_BIOME_ERUPTING_INFERNO)).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome undergrowth(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.MONSTER, 50, new MobSpawnSettings.SpawnerData(EntityType.GHAST, 4, 4));
        spawnBuilder.addSpawn(MobCategory.MONSTER, 2, new MobSpawnSettings.SpawnerData(EntityType.MAGMA_CUBE, 4, 4));
        spawnBuilder.addSpawn(MobCategory.MONSTER, 9, new MobSpawnSettings.SpawnerData(EntityType.HOGLIN, 3, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, 60, new MobSpawnSettings.SpawnerData(EntityType.STRIDER, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        biomeBuilder.addCarver(Carvers.NETHER_CAVE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.SPRING_OPEN);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.PATCH_FIRE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.PATCH_SOUL_FIRE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.GLOWSTONE_EXTRA);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.GLOWSTONE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.BROWN_MUSHROOM_NETHER);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.RED_MUSHROOM_NETHER);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)OrePlacements.ORE_MAGMA);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.SPRING_CLOSED);
        BiomeDefaultFeatures.addNetherDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.TREES_UNDERGROWTH);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.FLOWER_UNDERGROWTH);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.NETHER_BRAMBLE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.SPROUTS_UNDERGROWTH);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.DEAD_GRASS_45);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.NETHER_VINES);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).setAttribute(EnvironmentAttributes.SKY_COLOR, (Object)BOPOverworldBiomes.calculateSkyColor(2.0f)).setAttribute(EnvironmentAttributes.WATER_FOG_COLOR, (Object)329011).setAttribute(EnvironmentAttributes.FOG_COLOR, (Object)1843465).setAttribute(EnvironmentAttributes.AMBIENT_SOUNDS, (Object)new AmbientSounds(Optional.of(SoundEvents.AMBIENT_WARPED_FOREST_LOOP), Optional.of(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_CRIMSON_FOREST_MOOD, 6000, 8, 2.0)), List.of(new AmbientAdditionsSettings((Holder)SoundEvents.AMBIENT_NETHER_WASTES_ADDITIONS, 0.0111)))).setAttribute(EnvironmentAttributes.AMBIENT_PARTICLES, (Object)AmbientParticle.of((ParticleOptions)ParticleTypes.SPORE_BLOSSOM_AIR, (float)0.00357f)).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, (Object)new BackgroundMusic(BOPSounds.MUSIC_BIOME_UNDERGROWTH)).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome visceralHeap(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.MONSTER, 50, new MobSpawnSettings.SpawnerData(EntityType.GHAST, 4, 4));
        spawnBuilder.addSpawn(MobCategory.MONSTER, 100, new MobSpawnSettings.SpawnerData(EntityType.ZOMBIFIED_PIGLIN, 4, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, 60, new MobSpawnSettings.SpawnerData(EntityType.STRIDER, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        biomeBuilder.addCarver(Carvers.NETHER_CAVE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.SPRING_OPEN);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)OrePlacements.ORE_MAGMA);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)NetherPlacements.SPRING_CLOSED);
        BiomeDefaultFeatures.addNetherDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.BLOOD_LAKE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.BLOOD_SPRING);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.NETHER_BONE_SPINE);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.FLESH_TENDON);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.HANGING_FLESH_TENDONS);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.POROUS_FLESH);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.PUS_BUBBLES);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.EYEBULB);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.HAIR);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).setAttribute(EnvironmentAttributes.SKY_COLOR, (Object)BOPOverworldBiomes.calculateSkyColor(2.0f)).setAttribute(EnvironmentAttributes.WATER_FOG_COLOR, (Object)329011).setAttribute(EnvironmentAttributes.FOG_COLOR, (Object)6299416).setAttribute(EnvironmentAttributes.AMBIENT_SOUNDS, (Object)new AmbientSounds(Optional.of(SoundEvents.AMBIENT_NETHER_WASTES_LOOP), Optional.of(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_MOOD, 6000, 8, 2.0)), List.of(new AmbientAdditionsSettings((Holder)SoundEvents.AMBIENT_CRIMSON_FOREST_ADDITIONS, 0.0111)))).setAttribute(EnvironmentAttributes.AMBIENT_PARTICLES, (Object)AmbientParticle.of((ParticleOptions)ParticleTypes.SPORE_BLOSSOM_AIR, (float)0.00357f)).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, (Object)new BackgroundMusic(BOPSounds.MUSIC_BIOME_VISCERAL_HEAP)).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome witheredAbyss(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.MONSTER, 50, new MobSpawnSettings.SpawnerData(EntityType.ENDERMAN, 4, 4));
        spawnBuilder.addSpawn(MobCategory.MONSTER, 50, new MobSpawnSettings.SpawnerData(EntityType.WITHER_SKELETON, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        biomeBuilder.addCarver(Carvers.NETHER_CAVE);
        BiomeDefaultFeatures.addNetherDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.OBSIDIAN_SPLATTER);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.BLACKSTONE_SPINES);
        BOPNetherBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, BOPNetherPlacements.BLACKSTONE_BULBS);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).setAttribute(EnvironmentAttributes.SKY_COLOR, (Object)BOPOverworldBiomes.calculateSkyColor(2.0f)).setAttribute(EnvironmentAttributes.WATER_FOG_COLOR, (Object)329011).setAttribute(EnvironmentAttributes.FOG_COLOR, (Object)657169).setAttribute(EnvironmentAttributes.AMBIENT_SOUNDS, (Object)new AmbientSounds(Optional.of(SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP), Optional.of(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_MOOD, 6000, 8, 2.0)), List.of(new AmbientAdditionsSettings((Holder)SoundEvents.AMBIENT_CRIMSON_FOREST_ADDITIONS, 0.0111)))).setAttribute(EnvironmentAttributes.AMBIENT_PARTICLES, (Object)AmbientParticle.of((ParticleOptions)ParticleTypes.SPORE_BLOSSOM_AIR, (float)0.00357f)).setAttribute(EnvironmentAttributes.BACKGROUND_MUSIC, (Object)new BackgroundMusic(BOPSounds.MUSIC_BIOME_WITHERED_ABYSS)).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).grassColorOverride(3222582).foliageColorOverride(3222582).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }
}

