/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlowerBlockBOP
extends FlowerBlock {
    protected static final VoxelShape SHORT = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    protected static final VoxelShape NORMAL = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    protected static final VoxelShape MEDIUM = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
    protected static final VoxelShape LARGE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public FlowerBlockBOP(Holder<MobEffect> effect, BlockBehaviour.Properties properties) {
        super(effect, 0.0f, properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        Block block = state.getBlock();
        VoxelShape shape = NORMAL;
        if (block == BOPBlocks.LAVENDER || block == BOPBlocks.WHITE_LAVENDER || block == BOPBlocks.PINK_HIBISCUS) {
            shape = LARGE;
        }
        if (block == BOPBlocks.PINK_DAFFODIL || block == BOPBlocks.GLOWFLOWER || block == BOPBlocks.WILTED_LILY) {
            shape = MEDIUM;
        }
        if (block == BOPBlocks.VIOLET || block == BOPBlocks.ENDBLOOM) {
            shape = SHORT;
        }
        Vec3 vec3 = state.getOffset(pos);
        return shape.move(vec3.x, vec3.y, vec3.z);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Block ground = worldIn.getBlockState(pos.below()).getBlock();
        if (this == BOPBlocks.BURNING_BLOSSOM) {
            return ground == Blocks.NETHERRACK || ground == Blocks.SOUL_SAND || ground == Blocks.SOUL_SOIL || ground == Blocks.CRIMSON_NYLIUM || ground == Blocks.WARPED_NYLIUM || super.canSurvive(state, worldIn, pos);
        }
        if (this == BOPBlocks.WILTED_LILY) {
            return ground == BOPBlocks.DRIED_SALT || super.canSurvive(state, worldIn, pos);
        }
        if (this == BOPBlocks.ENDBLOOM) {
            return ground == BOPBlocks.ALGAL_END_STONE || ground == BOPBlocks.UNMAPPED_END_STONE || ground == BOPBlocks.NULL_END_STONE || ground == Blocks.END_STONE || super.canSurvive(state, worldIn, pos);
        }
        return super.canSurvive(state, worldIn, pos);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean b) {
        Block block = state.getBlock();
        if (block == BOPBlocks.BURNING_BLOSSOM && entity.getType() != EntityType.HOGLIN && entity.getType() != EntityType.PIGLIN && entity.getType() != EntityType.PIGLIN_BRUTE) {
            if (!entity.fireImmune()) {
                entity.setRemainingFireTicks(entity.getRemainingFireTicks() + 1);
                if (entity.getRemainingFireTicks() == 0) {
                    entity.igniteForSeconds(1.0f);
                }
            }
            entity.hurt(level.damageSources().inFire(), 1.0f);
        }
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        Block block = stateIn.getBlock();
        if (block == BOPBlocks.BURNING_BLOSSOM) {
            if (rand.nextInt(8) == 0) {
                worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 4.0, (double)pos.getY() + 0.75, (double)pos.getZ() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 4.0, 0.0, 0.0, 0.0);
            }
            if (rand.nextInt(4) == 0) {
                worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 4.0, (double)pos.getY() + 0.75, (double)pos.getZ() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 4.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

