/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.block.VegetationBlockBOP;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FoliageBlockBOP
extends VegetationBlockBOP {
    public static final MapCodec<FoliageBlockBOP> CODEC = FoliageBlockBOP.simpleCodec(FoliageBlockBOP::new);
    protected static final VoxelShape NORMAL = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    protected static final VoxelShape SHORT = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);

    public FoliageBlockBOP(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<FoliageBlockBOP> codec() {
        return CODEC;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        Block block = state.getBlock();
        if (block == BOPBlocks.DESERT_GRASS) {
            return SHORT;
        }
        return NORMAL;
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        if (!worldIn.isClientSide() && stack.getItem() == Items.SHEARS) {
            player.awardStat(Stats.BLOCK_MINED.get((Object)this));
            player.causeFoodExhaustion(0.005f);
            FoliageBlockBOP.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
        } else {
            super.playerDestroy(worldIn, player, pos, state, te, stack);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState groundState = worldIn.getBlockState(pos.below());
        Block ground = groundState.getBlock();
        if (this == BOPBlocks.SPROUT) {
            return groundState.isFaceSturdy((BlockGetter)worldIn, pos.below(), Direction.UP) || super.canSurvive(state, worldIn, pos);
        }
        if (this == BOPBlocks.DUNE_GRASS) {
            return groundState.is(BlockTags.SAND);
        }
        if (this == BOPBlocks.DESERT_GRASS || this == BOPBlocks.DEAD_GRASS) {
            return groundState.is(BlockTags.SAND) || ground == BOPBlocks.DRIED_SALT || ground == Blocks.GRAVEL || ground == Blocks.NETHERRACK || super.canSurvive(state, worldIn, pos);
        }
        if (this == BOPBlocks.ENDERPHYTE) {
            return ground == BOPBlocks.ALGAL_END_STONE || ground == BOPBlocks.UNMAPPED_END_STONE || ground == BOPBlocks.NULL_END_STONE || ground == Blocks.END_STONE;
        }
        return super.canSurvive(state, worldIn, pos);
    }

    public void animateTick(BlockState p_401875_, Level p_401809_, BlockPos p_401789_, RandomSource p_401918_) {
        if (this == BOPBlocks.DUNE_GRASS && p_401918_.nextInt(75) == 0) {
            BlockState blockstate = p_401809_.getBlockState(p_401789_.below());
            if (blockstate.is(Blocks.SAND) && p_401918_.nextInt(10) != 0) {
                return;
            }
            BlockState blockstate1 = p_401809_.getBlockState(p_401789_.below(2));
            if (blockstate.is(BlockTags.TRIGGERS_AMBIENT_DESERT_DRY_VEGETATION_BLOCK_SOUNDS) && blockstate1.is(BlockTags.TRIGGERS_AMBIENT_DESERT_DRY_VEGETATION_BLOCK_SOUNDS)) {
                p_401809_.playLocalSound((double)p_401789_.getX(), (double)p_401789_.getY(), (double)p_401789_.getZ(), SoundEvents.DEAD_BUSH_IDLE, SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
        }
    }
}

