/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block.entity;

import biomesoplenty.api.block.BOPBlockEntities;
import biomesoplenty.block.AnomalyBlock;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AnomalyBlockEntity
extends BlockEntity {
    private long lastTime = -1L;
    private BlockState lastState = null;
    private static final int MAX_NUM_MODEL_STATES = 500;
    private static final Supplier<List<BlockState>> MODEL_STATES = Suppliers.memoize(() -> {
        ArrayList allBlocks = BuiltInRegistries.BLOCK.listElements().filter(b -> b.key().identifier().getNamespace().equals("minecraft") && ((Block)b.value()).defaultBlockState().getRenderShape() == RenderShape.MODEL).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(allBlocks);
        ArrayList<BlockState> states = new ArrayList<BlockState>(500);
        RandomSource random = RandomSource.create();
        for (int i = 0; i < 500; ++i) {
            Holder.Reference block = (Holder.Reference)allBlocks.get(i % allBlocks.size());
            ImmutableList blockPossibleStates = ((Block)block.value()).getStateDefinition().getPossibleStates();
            states.add((BlockState)blockPossibleStates.get(random.nextInt(blockPossibleStates.size())));
        }
        return states;
    });

    public AnomalyBlockEntity(BlockPos pos, BlockState state) {
        super(BOPBlockEntities.ANOMALY, pos, state);
    }

    public BlockState getRenderState() {
        BlockState renderState;
        Level level = this.getLevel();
        if (level == null) {
            return Blocks.AIR.defaultBlockState();
        }
        long time = level.getGameTime();
        if (this.lastTime == time && this.lastState != null) {
            return this.lastState;
        }
        RandomSource random = RandomSource.create((long)Mth.getSeed((Vec3i)this.getBlockPos()));
        BlockState state = this.getBlockState();
        List<BlockState> renderStates = MODEL_STATES.get();
        int index = random.nextInt(renderStates.size());
        switch ((AnomalyBlock.AnomalyType)((Object)state.getValue(AnomalyBlock.ANOMALY_TYPE))) {
            case VOLATILE: {
                index *= (int)(time / 2L);
                break;
            }
            case QUIRKY: {
                index += (int)(time / 10L);
                break;
            }
            case UNSTABLE: {
                float slowWeight = 0.98f;
                int mode = (Mth.sign((double)(Mth.sin((double)((float)time / 20.0f)) + 0.98f)) + 1) / 2;
                if (mode > 0) {
                    index += (int)(time / 100L);
                    break;
                }
                index += (int)time;
            }
        }
        index = Mth.positiveModulo((int)index, (int)renderStates.size());
        this.lastState = renderState = (BlockState)renderStates.stream().skip(index).findFirst().orElseThrow();
        this.lastTime = time;
        return renderState;
    }
}

