/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.neoforge.client;

import biomesoplenty.neoforge.init.ModFluidTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.FogEnvironment;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

@EventBusSubscriber(modid="biomesoplenty")
public class FluidClientHandler {
    @SubscribeEvent
    public static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final Identifier BLOOD_UNDERWATER = Identifier.parse((String)"biomesoplenty:textures/block/blood_underwater.png");
            private static final Identifier BLOOD_STILL = Identifier.parse((String)"biomesoplenty:block/blood_still");
            private static final Identifier BLOOD_FLOW = Identifier.parse((String)"biomesoplenty:block/blood_flow");

            public Identifier getStillTexture() {
                return BLOOD_STILL;
            }

            public Identifier getFlowingTexture() {
                return BLOOD_FLOW;
            }

            public Identifier getRenderOverlayTexture(Minecraft mc) {
                return BLOOD_UNDERWATER;
            }

            public Vector4f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector4f fluidFogColor) {
                return new Vector4f(0.407f, 0.121f, 0.137f, fluidFogColor.w);
            }

            public void modifyFogRender(Camera camera, @Nullable FogEnvironment environment, float renderDistance, float partialTick, FogData fogData) {
                fogData.environmentalStart = 0.125f;
                fogData.environmentalEnd = 5.0f;
            }
        }, new Holder[]{ModFluidTypes.BLOOD_TYPE});
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final Identifier LIQUID_NULL_UNDERWATER = Identifier.parse((String)"biomesoplenty:textures/block/liquid_null_underwater.png");
            private static final Identifier LIQUID_NULL_STILL = Identifier.parse((String)"biomesoplenty:block/liquid_null_still");
            private static final Identifier LIQUID_NULL_FLOW = Identifier.parse((String)"biomesoplenty:block/liquid_null_flow");

            public Identifier getStillTexture() {
                return LIQUID_NULL_STILL;
            }

            public Identifier getFlowingTexture() {
                return LIQUID_NULL_FLOW;
            }

            public Identifier getRenderOverlayTexture(Minecraft mc) {
                return LIQUID_NULL_UNDERWATER;
            }

            public Vector4f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector4f fluidFogColor) {
                return new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
            }

            public void modifyFogRender(Camera camera, @Nullable FogEnvironment environment, float renderDistance, float partialTick, FogData fogData) {
                fogData.environmentalStart = 0.1f;
                fogData.environmentalEnd = 2.5f;
            }
        }, new Holder[]{ModFluidTypes.LIQUID_NULL_TYPE});
    }
}

