/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.neoforge.datagen;

import biomesoplenty.init.ModBiomes;
import biomesoplenty.init.ModDamageTypes;
import biomesoplenty.init.ModJukeboxSongs;
import biomesoplenty.neoforge.datagen.BOPModelProvider;
import biomesoplenty.neoforge.datagen.provider.BOPDataMapProvider;
import biomesoplenty.neoforge.datagen.provider.BOPLootTableProvider;
import biomesoplenty.neoforge.datagen.provider.BOPRecipeProvider;
import biomesoplenty.util.worldgen.BOPFeatureUtils;
import biomesoplenty.util.worldgen.BOPPlacementUtils;
import biomesoplenty.worldgen.carver.BOPConfiguredCarvers;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="biomesoplenty")
public class DataGenerationHandler {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_CARVER, BOPConfiguredCarvers::bootstrap).add(Registries.CONFIGURED_FEATURE, BOPFeatureUtils::bootstrap).add(Registries.PLACED_FEATURE, BOPPlacementUtils::bootstrap).add(Registries.BIOME, ModBiomes::bootstrapBiomes).add(Registries.DAMAGE_TYPE, ModDamageTypes::bootstrap).add(Registries.JUKEBOX_SONG, ModJukeboxSongs::bootstrap);

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, BUILDER, Set.of("biomesoplenty")));
        generator.addProvider(true, (DataProvider)new BOPRecipeProvider.Runner(output, event.getLookupProvider()));
        generator.addProvider(true, (DataProvider)BOPLootTableProvider.create(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new BOPDataMapProvider(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new BOPModelProvider(output));
    }
}

