/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.PalmTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class PalmTreeFeature
extends BOPTreeFeature<PalmTreeConfiguration> {
    public PalmTreeFeature(Codec<PalmTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        PalmTreeConfiguration config = (PalmTreeConfiguration)configBase;
        while (startPos.getY() >= world.getMinY() + 1 && world.isEmptyBlock(startPos) || world.getBlockState(startPos).is(BlockTags.LEAVES)) {
            startPos = startPos.below();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        int leavesRadius = 2;
        int heightMinusTop = height - leavesRadius - 1;
        boolean slant = true;
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        if (random.nextInt(8) == 0) {
            slant = false;
        }
        double baseSlant = (double)(5 + random.nextInt(30)) / 100.0;
        double slantMultiplier = 1.3;
        if (height < 8) {
            return false;
        }
        BlockPos pos = startPos.above();
        if (!this.checkSpace((LevelAccessor)world, pos, height, 1)) {
            return false;
        }
        double slantOffset = baseSlant;
        for (int step = 0; step <= heightMinusTop; ++step) {
            BlockPos offsetPos = pos.above(step);
            if (slant) {
                offsetPos = pos.above(step).relative(direction, (int)Math.floor(slantOffset));
            }
            if (step == heightMinusTop) {
                this.placeLog((LevelAccessor)world, offsetPos, logs, config);
                this.generateLeavesTop((LevelAccessor)world, offsetPos, leavesRadius, leaves, config);
                break;
            }
            this.placeLog((LevelAccessor)world, offsetPos, logs, config);
            slantOffset *= slantMultiplier;
        }
        return true;
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int height, int radius) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.offset(x, y, z);
                    if (pos1.getY() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeavesTop(LevelAccessor world, BlockPos pos, int maxRadius, FoliagePlacer.FoliageSetter leaves, PalmTreeConfiguration config) {
        this.placeLeaves(world, pos.offset(2, -2, 0), leaves, config);
        this.placeLeaves(world, pos.offset(-2, -2, 0), leaves, config);
        this.placeLeaves(world, pos.offset(0, -2, 2), leaves, config);
        this.placeLeaves(world, pos.offset(0, -2, -2), leaves, config);
        this.placeLeaves(world, pos.offset(2, -1, 0), leaves, config);
        this.placeLeaves(world, pos.offset(-2, -1, 0), leaves, config);
        this.placeLeaves(world, pos.offset(0, -1, 2), leaves, config);
        this.placeLeaves(world, pos.offset(0, -1, -2), leaves, config);
        this.placeLeaves(world, pos.offset(1, -1, 0), leaves, config);
        this.placeLeaves(world, pos.offset(-1, -1, 0), leaves, config);
        this.placeLeaves(world, pos.offset(0, -1, 1), leaves, config);
        this.placeLeaves(world, pos.offset(0, -1, -1), leaves, config);
        this.placeLeaves(world, pos.offset(1, 0, 0), leaves, config);
        this.placeLeaves(world, pos.offset(-1, 0, 0), leaves, config);
        this.placeLeaves(world, pos.offset(0, 0, 1), leaves, config);
        this.placeLeaves(world, pos.offset(0, 0, -1), leaves, config);
        this.placeLeaves(world, pos.offset(1, 0, 1), leaves, config);
        this.placeLeaves(world, pos.offset(-1, 0, -1), leaves, config);
        this.placeLeaves(world, pos.offset(-1, 0, 1), leaves, config);
        this.placeLeaves(world, pos.offset(1, 0, -1), leaves, config);
        this.placeLeaves(world, pos.offset(2, 0, 2), leaves, config);
        this.placeLeaves(world, pos.offset(-2, 0, -2), leaves, config);
        this.placeLeaves(world, pos.offset(2, 0, -2), leaves, config);
        this.placeLeaves(world, pos.offset(-2, 0, 2), leaves, config);
        this.placeLeaves(world, pos.offset(2, 1, 2), leaves, config);
        this.placeLeaves(world, pos.offset(-2, 1, -2), leaves, config);
        this.placeLeaves(world, pos.offset(2, 1, -2), leaves, config);
        this.placeLeaves(world, pos.offset(-2, 1, 2), leaves, config);
        this.placeLeaves(world, pos.offset(1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.offset(-1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.offset(1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.offset(-1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.offset(0, 1, 0), leaves, config);
        this.placeLeaves(world, pos.offset(-2, 1, 1), leaves, config);
        this.placeLeaves(world, pos.offset(2, 1, 1), leaves, config);
        this.placeLeaves(world, pos.offset(-2, 1, -1), leaves, config);
        this.placeLeaves(world, pos.offset(2, 1, -1), leaves, config);
        this.placeLeaves(world, pos.offset(-1, 1, 2), leaves, config);
        this.placeLeaves(world, pos.offset(1, 1, 2), leaves, config);
        this.placeLeaves(world, pos.offset(-1, 1, -2), leaves, config);
        this.placeLeaves(world, pos.offset(1, 1, -2), leaves, config);
        this.placeLeaves(world, pos.offset(1, 2, 1), leaves, config);
        this.placeLeaves(world, pos.offset(-1, 2, -1), leaves, config);
        this.placeLeaves(world, pos.offset(-1, 2, 1), leaves, config);
        this.placeLeaves(world, pos.offset(1, 2, -1), leaves, config);
    }
}

