/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.TaigaTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class TaigaTreeFeature
extends BOPTreeFeature<TaigaTreeConfiguration> {
    public TaigaTreeFeature(Codec<TaigaTreeConfiguration> codec) {
        super(codec);
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int baseHeight, int height, TaigaTreeConfiguration config) {
        for (int y = 0; y <= height; ++y) {
            int trunkWidth = config.trunkWidth * (height - y) / height + 1;
            int trunkStart = Mth.ceil((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = Mth.floor((double)(0.25 + (double)trunkWidth / 2.0));
            int start = y <= baseHeight ? trunkStart : trunkStart - 1;
            int end = y <= baseHeight ? trunkEnd : trunkEnd + 1;
            for (int x = start; x <= end; ++x) {
                for (int z = start; z <= end; ++z) {
                    BlockPos pos1 = pos.offset(x, y, z);
                    if (pos1.getY() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(LevelAccessor world, RandomSource rand, BlockPos pos, int leavesRadius, int trunkStart, int trunkEnd, FoliagePlacer.FoliageSetter leaves, TaigaTreeConfiguration config) {
        int start = trunkStart - leavesRadius;
        int end = trunkEnd + leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                int distFromTrunk;
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || (distFromTrunk = (x < 0 ? trunkStart - x : x - trunkEnd) + (z < 0 ? trunkStart - z : z - trunkEnd)) >= 4 && (distFromTrunk != 4 || rand.nextInt(2) != 0)) continue;
                this.placeLeaves(world, pos.offset(x, 0, z), leaves, config);
            }
        }
    }

    public void generateBranch(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, int length, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TaigaTreeConfiguration config) {
        Direction.Axis axis = direction.getAxis();
        Direction sideways = direction.getClockWise();
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.relative(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.nextInt(2) != 0) continue;
                this.placeLeaves(world, pos1.relative(sideways, j), leaves, config);
            }
            if (length - i <= 2) continue;
            this.placeLeaves(world, pos1.above(), leaves, config);
            this.placeLeaves(world, pos1.above().relative(sideways, -1), leaves, config);
            this.placeLeaves(world, pos1.above().relative(sideways, 1), leaves, config);
            this.placeLog(world, pos1, axis, logs, config);
        }
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        int trunkEnd;
        int trunkStart;
        int trunkWidth;
        int baseHeight;
        TaigaTreeConfiguration config = (TaigaTreeConfiguration)configBase;
        while (startPos.getY() >= world.getMinY() + 1 && world.isEmptyBlock(startPos) || world.getBlockState(startPos).is(BlockTags.LEAVES)) {
            startPos = startPos.below();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        int leavesHeight = height - (baseHeight = GeneratorUtil.nextIntBetween(random, height / 5, height / 3));
        if (leavesHeight < 3) {
            return false;
        }
        if (!this.checkSpace((LevelAccessor)world, startPos.above(), baseHeight, height, config)) {
            return false;
        }
        BlockPos pos = startPos.above(height);
        this.placeLeaves((LevelAccessor)world, pos, leaves, config);
        pos.below();
        for (int i = 0; i < leavesHeight; ++i) {
            trunkWidth = config.trunkWidth * i / height + 1;
            trunkStart = Mth.ceil((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = Mth.floor((double)(0.25 + (double)trunkWidth / 2.0));
            int radius = Math.min(Math.min((i + 2) / 3, 3 + (leavesHeight - i)), 6);
            if (radius == 0) {
                this.placeLeaves((LevelAccessor)world, pos, leaves, config);
            } else if (radius < 4) {
                if (i % 2 == 0) {
                    this.generateLeafLayer((LevelAccessor)world, random, pos, radius, trunkStart, trunkEnd, leaves, config);
                } else {
                    this.generateLeafLayer((LevelAccessor)world, random, pos, radius / 2, trunkStart, trunkEnd, leaves, config);
                }
            } else if (i % 2 == 0) {
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkStart, 0, trunkStart), Direction.NORTH, radius, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkEnd, 0, trunkStart), Direction.EAST, radius, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkEnd, 0, trunkEnd), Direction.SOUTH, radius, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkStart, 0, trunkEnd), Direction.WEST, radius, logs, leaves, config);
            }
            pos = pos.below();
        }
        for (int y = 0; y < height - 1; ++y) {
            trunkWidth = config.trunkWidth * (height - y) / height + 1;
            trunkStart = Mth.ceil((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = Mth.floor((double)(0.25 + (double)trunkWidth / 2.0));
            if (trunkWidth < 1 || trunkWidth > config.trunkWidth) {
                trunkStart = 0;
                trunkEnd = 0;
            }
            for (int x = trunkStart; x <= trunkEnd; ++x) {
                for (int z = trunkStart; z <= trunkEnd; ++z) {
                    if (y == 1) {
                        world.setBlock(startPos.offset(x, y - 1, z), Blocks.DIRT.defaultBlockState(), 3);
                    }
                    this.placeLog((LevelAccessor)world, startPos.offset(x, y, z), logs, config);
                }
            }
        }
        return true;
    }
}

