/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block.entity;

import biomesoplenty.api.block.BOPBlockEntities;
import biomesoplenty.block.AnomalyBlock;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class AnomalyBlockEntity
extends class_2586 {
    private long lastTime = -1L;
    private class_2680 lastState = null;
    private static final int MAX_NUM_MODEL_STATES = 500;
    private static final Supplier<List<class_2680>> MODEL_STATES = Suppliers.memoize(() -> {
        ArrayList allBlocks = class_7923.field_41175.method_42017().filter(b -> b.method_40237().method_29177().method_12836().equals("minecraft") && ((class_2248)b.comp_349()).method_9564().method_26217() == class_2464.field_11458).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(allBlocks);
        ArrayList<class_2680> states = new ArrayList<class_2680>(500);
        class_5819 random = class_5819.method_43047();
        for (int i = 0; i < 500; ++i) {
            class_6880.class_6883 block = (class_6880.class_6883)allBlocks.get(i % allBlocks.size());
            ImmutableList blockPossibleStates = ((class_2248)block.comp_349()).method_9595().method_11662();
            states.add((class_2680)blockPossibleStates.get(random.method_43048(blockPossibleStates.size())));
        }
        return states;
    });

    public AnomalyBlockEntity(class_2338 pos, class_2680 state) {
        super(BOPBlockEntities.ANOMALY, pos, state);
    }

    public class_2680 getRenderState() {
        class_2680 renderState;
        class_1937 level = this.method_10997();
        if (level == null) {
            return class_2246.field_10124.method_9564();
        }
        long time = level.method_8510();
        if (this.lastTime == time && this.lastState != null) {
            return this.lastState;
        }
        class_5819 random = class_5819.method_43049((long)class_3532.method_15389((class_2382)this.method_11016()));
        class_2680 state = this.method_11010();
        List<class_2680> renderStates = MODEL_STATES.get();
        int index = random.method_43048(renderStates.size());
        switch ((AnomalyBlock.AnomalyType)((Object)state.method_11654(AnomalyBlock.ANOMALY_TYPE))) {
            case VOLATILE: {
                index *= (int)(time / 2L);
                break;
            }
            case QUIRKY: {
                index += (int)(time / 10L);
                break;
            }
            case UNSTABLE: {
                float slowWeight = 0.98f;
                int mode = (class_3532.method_17822((double)(class_3532.method_15374((float)((float)time / 20.0f)) + 0.98f)) + 1) / 2;
                if (mode > 0) {
                    index += (int)(time / 100L);
                    break;
                }
                index += (int)time;
            }
        }
        index = class_3532.method_15387((int)index, (int)renderStates.size());
        this.lastState = renderState = (class_2680)renderStates.stream().skip(index).findFirst().orElseThrow();
        this.lastTime = time;
        return renderState;
    }
}

