/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import com.mojang.serialization.MapCodec;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LumaloopBlock
extends GrowingPlantHeadBlock {
    public static final MapCodec<LumaloopBlock> CODEC = LumaloopBlock.simpleCodec(LumaloopBlock::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final int MAX_AGE = 8;
    private final double growPerTickProbability;

    public LumaloopBlock(BlockBehaviour.Properties p_i241195_1_) {
        super(p_i241195_1_, Direction.UP, SHAPE, false, 0.01);
        this.growPerTickProbability = 0.01;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<LumaloopBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(context.getLevel().getRandom().nextInt(8)));
    }

    public boolean isRandomlyTicking(BlockState p_53961_) {
        return (Integer)p_53961_.getValue((Property)AGE) < 8;
    }

    public BlockState getMaxAgeState(BlockState p_187439_) {
        return (BlockState)p_187439_.setValue((Property)AGE, (Comparable)Integer.valueOf(8));
    }

    public boolean isMaxAge(BlockState p_187441_) {
        return (Integer)p_187441_.getValue((Property)AGE) == 8;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource p_220928_) {
        return 1;
    }

    protected BlockState getGrowIntoState(BlockState p_220935_, RandomSource p_220936_) {
        return (BlockState)super.getGrowIntoState(p_220935_, p_220936_).setValue((Property)LIT, (Comparable)Boolean.valueOf(p_220936_.nextFloat() < 0.4f));
    }

    public void performBonemeal(ServerLevel p_221337_, RandomSource p_221338_, BlockPos p_221339_, BlockState p_221340_) {
        BlockPos blockpos = p_221339_.relative(this.growthDirection);
        int i = Math.min((Integer)p_221340_.getValue((Property)AGE) + 1, 8);
        int j = this.getBlocksToGrowWhenBonemealed(p_221338_);
        p_221337_.setBlock(p_221339_, (BlockState)p_221340_.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
        for (int k = 0; k < j && this.canGrowInto(p_221337_.getBlockState(blockpos)); ++k) {
            p_221337_.setBlockAndUpdate(blockpos, (BlockState)p_221340_.setValue((Property)AGE, (Comparable)Integer.valueOf(i)));
            blockpos = blockpos.relative(this.growthDirection);
            i = Math.min(i + 1, 8);
        }
    }

    protected BlockState updateBodyAfterConvertedFromHead(BlockState p_152987_, BlockState p_152988_) {
        return (BlockState)p_152988_.setValue((Property)LIT, (Comparable)((Boolean)p_152987_.getValue((Property)LIT)));
    }

    protected boolean canGrowInto(BlockState p_230334_1_) {
        return NetherVines.isValidGrowthState((BlockState)p_230334_1_);
    }

    protected Block getBodyBlock() {
        return BOPBlocks.LUMALOOP_PLANT;
    }

    public boolean canSurvive(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        BlockPos blockpos = p_196260_3_.relative(this.growthDirection.getOpposite());
        BlockState blockstate = p_196260_2_.getBlockState(blockpos);
        Block block = blockstate.getBlock();
        if (!this.canAttachTo(blockstate)) {
            return false;
        }
        return block == this.getHeadBlock() || block == this.getBodyBlock() || block == Blocks.END_STONE || block == BOPBlocks.UNMAPPED_END_STONE || block == BOPBlocks.NULL_END_STONE || block == BOPBlocks.ALGAL_END_STONE;
    }

    public static ToIntFunction<BlockState> lightLevel(int level) {
        return state -> (Boolean)state.getValue((Property)LIT) != false ? level : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_56651_) {
        p_56651_.add(new Property[]{AGE, LIT});
    }
}

