/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BigDripleafFeature
extends Feature<NoneFeatureConfiguration> {
    public BigDripleafFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos pos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        int i = 0;
        for (int j = 0; j < 32; ++j) {
            BlockPos blockpos = pos.offset(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!world.getBlockState(blockpos.below()).is(BlockTags.DIRT)) continue;
            int max_height = rand.nextInt(3) + 1;
            Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(rand);
            for (int k = 0; k < max_height; ++k) {
                if (!BigDripleafFeature.isAir((LevelSimulatedReader)world, blockpos.above(k)) && !world.getBlockState(blockpos.above(k)).liquid() && world.getBlockState(blockpos.above(k)).getBlock() != Blocks.BIG_DRIPLEAF && !(world.getBlockState(blockpos.above(k)).getBlock() instanceof VegetationBlock)) break;
                if (BigDripleafFeature.isAir((LevelSimulatedReader)world, blockpos.above(k - 1)) || world.getBlockState(blockpos.above(k - 1)).liquid() || world.getBlockState(blockpos.above(k - 1)).getBlock() == Blocks.BIG_DRIPLEAF || world.getBlockState(blockpos.above(k - 1)).getBlock() instanceof VegetationBlock) {
                    world.setBlock(blockpos.above(k - 1), BigDripleafFeature.copyWaterloggedFrom((LevelReader)world, blockpos.above(k - 1), (BlockState)Blocks.BIG_DRIPLEAF_STEM.defaultBlockState().setValue((Property)SmallDripleafBlock.FACING, (Comparable)direction)), 2);
                }
                world.setBlock(blockpos.above(k), BigDripleafFeature.copyWaterloggedFrom((LevelReader)world, blockpos.above(k), (BlockState)Blocks.BIG_DRIPLEAF.defaultBlockState().setValue((Property)SmallDripleafBlock.FACING, (Comparable)direction)), 2);
            }
            ++i;
        }
        return i > 0;
    }

    public static BlockState copyWaterloggedFrom(LevelReader p_182454_, BlockPos p_182455_, BlockState p_182456_) {
        return p_182456_.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)p_182456_.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(p_182454_.isWaterAt(p_182455_))) : p_182456_;
    }

    public static boolean isAir(LevelSimulatedReader p_65811_, BlockPos p_65812_) {
        return p_65811_.isStateAtPosition(p_65812_, BlockBehaviour.BlockStateBase::isAir);
    }
}

