/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.init.ModTags;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WispjellyFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.getBlockState(pos).is(ModTags.Blocks.TIDEPOOL_REPLACEABLE);
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos) || world.getBlockState(pos).getBlock() instanceof VegetationBlock || world.getBlockState(pos).is(ModTags.Blocks.DEAD_CORALS);

    public WispjellyFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos startPos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        while (startPos.getY() >= world.getMinY() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.below();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = 8 + rand.nextInt(56);
        if (!this.checkSpace(world, startPos.above(), height)) {
            return false;
        }
        BlockPos pos = startPos.above(height);
        if (rand.nextInt(4) == 0) {
            this.createLargeJelly(world, pos);
        } else if (rand.nextInt(2) == 0) {
            this.createSmallJelly(world, pos);
        } else {
            this.createTinyJelly(world, pos);
        }
        return true;
    }

    public void createTinyJelly(WorldGenLevel world, BlockPos pos) {
        this.setBlock(world, pos.offset(-1, 1, 0), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(1, 1, 0), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(0, 1, 1), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(0, 1, -1), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(0, 0, 0), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(-1, 0, 0), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(1, 0, 0), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(0, 0, 1), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(0, 0, -1), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(1, 0, 1), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(1, 0, -1), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(-1, 0, 1), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(-1, 0, -1), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(-1, -1, 0), BOPBlocks.WISPJELLY.defaultBlockState());
        this.setBlock(world, pos.offset(1, -1, 0), BOPBlocks.WISPJELLY.defaultBlockState());
    }

    public void createSmallJelly(WorldGenLevel world, BlockPos pos) {
        int x;
        for (x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.setBlock(world, pos.offset(x, y, z), BOPBlocks.WISPJELLY.defaultBlockState());
                }
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if ((x == -2 || x == 2) && (z == -2 || z == 2)) continue;
                this.setBlock(world, pos.offset(x, 0, z), BOPBlocks.WISPJELLY.defaultBlockState());
            }
        }
        int length = 2;
        for (int i = 0; i < length; ++i) {
            this.setBlock(world, pos.offset(1, -(i + 1), 1), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(1, -(i + 1), -1), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(-1, -(i + 1), 1), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(-1, -(i + 1), -1), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(1, -(i + 2), 1), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(-1, -(i + 2), -1), BOPBlocks.WISPJELLY.defaultBlockState());
        }
    }

    public void createLargeJelly(WorldGenLevel world, BlockPos pos) {
        int x;
        for (x = -2; x <= 2; ++x) {
            for (int y = 0; y <= 3; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    if ((x == -2 || x == 2) && (z == -2 || z == 2)) continue;
                    if (y == 3) {
                        if (x == -2 || x == 2 || z == -2 || z == 2) continue;
                        this.setBlock(world, pos.offset(x, y, z), BOPBlocks.WISPJELLY.defaultBlockState());
                        continue;
                    }
                    this.setBlock(world, pos.offset(x, y, z), BOPBlocks.WISPJELLY.defaultBlockState());
                }
            }
        }
        for (x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                if (Mth.abs((int)x) + Mth.abs((int)z) >= 5) continue;
                this.setBlock(world, pos.offset(x, 0, z), BOPBlocks.WISPJELLY.defaultBlockState());
            }
        }
        int length = 3;
        for (int i = 0; i < length; ++i) {
            this.setBlock(world, pos.offset(-1, -(i + 1), -2), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(1, -(i + 1), -2), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(-1, -(i + 1), 2), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(1, -(i + 1), 2), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(-2, -(i + 1), 0), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(2, -(i + 1), 0), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(-1, -(i + 2), -2), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(-1, -(i + 2), 2), BOPBlocks.WISPJELLY.defaultBlockState());
            this.setBlock(world, pos.offset(2, -(i + 2), 0), BOPBlocks.WISPJELLY.defaultBlockState());
        }
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.setBlock((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, int height) {
        for (int y = -3; y <= 3; ++y) {
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos pos1 = pos.offset(x, y + height, z);
                    if (pos1.getY() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

