/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.TaigaTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class RedwoodTreeFeature
extends BOPTreeFeature<TaigaTreeConfiguration> {
    public RedwoodTreeFeature(Codec<TaigaTreeConfiguration> codec) {
        super(codec);
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int baseHeight, int height, TaigaTreeConfiguration config) {
        for (int y = 0; y <= height; ++y) {
            int trunkWidth = config.trunkWidth * (height - y) / height + 1;
            int trunkStart = Mth.ceil((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = Mth.floor((double)(0.25 + (double)trunkWidth / 2.0));
            int start = y <= baseHeight ? trunkStart : trunkStart - 1;
            int end = y <= baseHeight ? trunkEnd : trunkEnd + 1;
            for (int x = start; x <= end; ++x) {
                for (int z = start; z <= end; ++z) {
                    BlockPos pos1 = pos.offset(x, y, z);
                    if (pos1.getY() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(LevelAccessor world, RandomSource rand, BlockPos pos, int leavesRadius, int trunkStart, int trunkEnd, FoliagePlacer.FoliageSetter leaves, TaigaTreeConfiguration config) {
        int start = trunkStart - leavesRadius;
        int end = trunkEnd + leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                int distFromTrunk;
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || (distFromTrunk = (x < 0 ? trunkStart - x : x - trunkEnd) + (z < 0 ? trunkStart - z : z - trunkEnd)) >= 4 && (distFromTrunk != 4 || rand.nextInt(2) != 0)) continue;
                this.placeLeaves(world, pos.offset(x, 0, z), leaves, config);
            }
        }
    }

    public void generateBranch(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, int length, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TaigaTreeConfiguration config) {
        Direction.Axis axis = direction.getAxis();
        Direction sideways = direction.getClockWise();
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.relative(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.nextInt(2) != 0) continue;
                this.placeLeaves(world, pos1.relative(sideways, j), leaves, config);
            }
            if (length - i <= 2) continue;
            this.placeLeaves(world, pos1.above(), leaves, config);
            this.placeLeaves(world, pos1.above().relative(sideways, -1), leaves, config);
            this.placeLeaves(world, pos1.above().relative(sideways, 1), leaves, config);
            this.placeLog(world, pos1, axis, logs, config);
        }
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        int baseHeight;
        TaigaTreeConfiguration config = (TaigaTreeConfiguration)configBase;
        while (startPos.getY() >= world.getMinY() + 1 && world.isEmptyBlock(startPos) || world.getBlockState(startPos).is(BlockTags.LEAVES)) {
            startPos = startPos.below();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        int leavesHeight = height - (baseHeight = GeneratorUtil.nextIntBetween(random, (int)((float)height * 0.6f), (int)((float)height * 0.4f)));
        if (leavesHeight < 3) {
            return false;
        }
        if (!this.checkSpace((LevelAccessor)world, startPos.above(), baseHeight, height, config)) {
            return false;
        }
        BlockPos pos = startPos.above(height);
        this.placeLeaves((LevelAccessor)world, pos, leaves, config);
        pos.below();
        for (int i = 0; i < leavesHeight; ++i) {
            int trunkWidth = config.trunkWidth * i / height + 1;
            int trunkStart = Mth.ceil((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = Mth.floor((double)(0.25 + (double)trunkWidth / 2.0));
            int radius = Math.min(Math.min((i + 2) / 4, 2 + (leavesHeight - i)), 4);
            if (radius == 0) {
                this.placeLeaves((LevelAccessor)world, pos, leaves, config);
            } else if (radius < 2) {
                this.generateLeafLayer((LevelAccessor)world, random, pos, radius, trunkStart, trunkEnd, leaves, config);
            } else if (i % 5 == 0) {
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkStart, 0, trunkStart), Direction.NORTH, radius / 2, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkEnd, 0, trunkStart), Direction.EAST, radius / 2, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkEnd, 0, trunkEnd), Direction.SOUTH, radius / 2, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkStart, 0, trunkEnd), Direction.WEST, radius / 2, logs, leaves, config);
            } else {
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkStart, 0, trunkStart), Direction.NORTH, radius, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkEnd, 0, trunkStart), Direction.EAST, radius, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkEnd, 0, trunkEnd), Direction.SOUTH, radius, logs, leaves, config);
                this.generateBranch((LevelAccessor)world, random, pos.offset(trunkStart, 0, trunkEnd), Direction.WEST, radius, logs, leaves, config);
            }
            pos = pos.below();
        }
        double[] scalingFactors = new double[]{0.35 + random.nextDouble() * 0.15, 0.07 + random.nextDouble() * 0.1, random.nextDouble() * 0.06};
        if (config.trunkWidth == 3) {
            scalingFactors = new double[]{0.6 + random.nextDouble() * 0.2, 0.1 + random.nextDouble() * 0.2, 0.03 + random.nextDouble() * 0.09};
        }
        for (int x = -config.trunkWidth; x <= config.trunkWidth; ++x) {
            for (int z = -config.trunkWidth; z <= config.trunkWidth; ++z) {
                BlockPos local;
                int y;
                int dist = Math.abs(x) + Math.abs(z);
                int heightHere = height - 2;
                if (config.trunkWidth == 1 && dist > 0) continue;
                if (dist == 1) {
                    heightHere = (int)((double)height * scalingFactors[0]);
                } else if (dist == 2) {
                    heightHere = (int)((double)height * scalingFactors[1]);
                } else if (dist == 3) {
                    heightHere = (int)((double)height * scalingFactors[2]);
                } else if (dist > 3) continue;
                heightHere += random.nextInt(2);
                boolean didPlace = false;
                for (y = 0; y < heightHere; ++y) {
                    double theta;
                    local = startPos.offset(x, y, z);
                    didPlace |= this.placeLog((LevelAccessor)world, local, logs, config);
                    if (dist <= 0 || y <= 6 || y >= baseHeight - 2 || random.nextInt(15) != 0) continue;
                    if (x == 0 && z == 0) {
                        if (y < 10) continue;
                        theta = Math.PI * random.nextDouble() * 2.0;
                    } else {
                        double angleFromCenter = Math.atan2(x, z);
                        theta = angleFromCenter + Math.PI * (random.nextDouble() * 0.5 - 0.25);
                    }
                    int branchLength = 3 - dist + 1 + random.nextInt(2);
                    BlockPos branchPos = null;
                    for (int i = 0; i < branchLength; ++i) {
                        branchPos = local.offset(Mth.floor((double)(Math.cos(theta) * (double)i)), i / 2, Mth.floor((double)(Math.sin(theta) * (double)i)));
                        this.placeLog((LevelAccessor)world, branchPos, logs, config);
                    }
                    this.generateBush(logs, leaves, (LevelAccessor)world, random, branchPos, config);
                }
                if (!didPlace) continue;
                for (y = 1; y < 4; ++y) {
                    local = startPos.offset(x, -y, z);
                    BlockState state = world.getBlockState(local);
                    if (!state.isAir() && !state.is(BlockTags.REPLACEABLE_BY_TREES) && !RedwoodTreeFeature.isDirt((BlockState)state)) continue;
                    world.setBlock(local, Blocks.DIRT.defaultBlockState(), 3);
                }
            }
        }
        return true;
    }

    protected boolean generateBush(BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, LevelAccessor world, RandomSource random, BlockPos pos, TaigaTreeConfiguration config) {
        int height = 2;
        for (int y = 0; y < height; ++y) {
            if (height - y > 1) {
                this.placeLog(world, pos.offset(0, y, 0), logs, config);
            }
            int leavesRadius = height - y > 1 ? 2 : 1;
            for (int x = -leavesRadius; x <= leavesRadius; ++x) {
                for (int z = -leavesRadius; z <= leavesRadius; ++z) {
                    if (Math.abs(x) >= leavesRadius && Math.abs(z) >= leavesRadius) continue;
                    if (config.altFoliageProvider.getState(random, pos) != Blocks.AIR.defaultBlockState()) {
                        if (random.nextInt(4) == 0) {
                            this.placeAltLeaves(world, pos.offset(x, y, z), leaves, config);
                            continue;
                        }
                        this.placeLeaves(world, pos.offset(x, y, z), leaves, config);
                        continue;
                    }
                    this.placeLeaves(world, pos.offset(x, y, z), leaves, config);
                }
            }
        }
        return true;
    }
}

