/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.block.VegetationBlockBOP;
import biomesoplenty.block.properties.QuarterProperty;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HugeLilyPadBlock
extends VegetationBlockBOP {
    public static final MapCodec<HugeLilyPadBlock> CODEC = HugeLilyPadBlock.simpleCodec(HugeLilyPadBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<QuarterProperty> QUARTER = EnumProperty.create((String)"quarter", QuarterProperty.class);
    protected static final VoxelShape AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);

    public HugeLilyPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(QUARTER, (Comparable)((Object)QuarterProperty.SOUTH_WEST)));
    }

    public MapCodec<HugeLilyPadBlock> codec() {
        return CODEC;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{QUARTER});
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos facingPos, BlockState facingState, RandomSource random) {
        boolean lilypadSurvive = true;
        Direction facing = (Direction)state.getValue(FACING);
        BlockPos sw = pos;
        BlockPos nw = pos.relative(facing);
        BlockPos ne = nw.relative(facing.getClockWise());
        BlockPos se = pos.relative(facing.getClockWise());
        if (state.getValue(QUARTER) == QuarterProperty.SOUTH_WEST) {
            sw = pos;
            nw = pos.relative(facing);
            ne = nw.relative(facing.getClockWise());
            se = pos.relative(facing.getClockWise());
        }
        if (state.getValue(QUARTER) == QuarterProperty.NORTH_WEST) {
            sw = pos.relative(facing.getOpposite());
            nw = pos;
            ne = pos.relative(facing.getClockWise());
            se = sw.relative(facing.getClockWise());
        }
        if (state.getValue(QUARTER) == QuarterProperty.NORTH_EAST) {
            nw = pos.relative(facing.getCounterClockWise());
            ne = pos;
            se = pos.relative(facing.getOpposite());
            sw = se.relative(facing);
        }
        if (state.getValue(QUARTER) == QuarterProperty.SOUTH_EAST) {
            sw = pos.relative(facing.getCounterClockWise());
            ne = pos.relative(facing);
            se = pos;
            nw = ne.relative(facing.getCounterClockWise());
        }
        if (!(level.getBlockState(sw).is((Block)this) && level.getBlockState(nw).is((Block)this) && level.getBlockState(ne).is((Block)this) && level.getBlockState(se).is((Block)this))) {
            lilypadSurvive = false;
        }
        if (level.getBlockState(sw).is((Block)this) && level.getBlockState(sw).getValue(FACING) != facing && level.getBlockState(sw).getValue(QUARTER) != QuarterProperty.SOUTH_WEST) {
            lilypadSurvive = false;
        }
        if (level.getBlockState(nw).is((Block)this) && level.getBlockState(nw).getValue(FACING) != facing && level.getBlockState(nw).getValue(QUARTER) != QuarterProperty.NORTH_WEST) {
            lilypadSurvive = false;
        }
        if (level.getBlockState(ne).is((Block)this) && level.getBlockState(ne).getValue(FACING) != facing && level.getBlockState(ne).getValue(QUARTER) != QuarterProperty.NORTH_EAST) {
            lilypadSurvive = false;
        }
        if (level.getBlockState(se).is((Block)this) && level.getBlockState(se).getValue(FACING) != facing && level.getBlockState(se).getValue(QUARTER) != QuarterProperty.SOUTH_EAST) {
            lilypadSurvive = false;
        }
        if (!lilypadSurvive) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, level, tickAccess, pos, direction, facingPos, facingState, random);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_49479_) {
        Direction direction = p_49479_.getHorizontalDirection();
        BlockPos blockpos = p_49479_.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(direction);
        BlockPos blockpos2 = blockpos1.relative(direction.getClockWise());
        BlockPos blockpos3 = blockpos.relative(direction.getClockWise());
        Level level = p_49479_.getLevel();
        return this.mayPlaceOn(level.getBlockState(blockpos1.below()), (BlockGetter)level, blockpos1.below()) && level.getBlockState(blockpos1).canBeReplaced(p_49479_) && level.getWorldBorder().isWithinBounds(blockpos1) && this.mayPlaceOn(level.getBlockState(blockpos2.below()), (BlockGetter)level, blockpos2.below()) && level.getBlockState(blockpos2).canBeReplaced(p_49479_) && level.getWorldBorder().isWithinBounds(blockpos2) && this.mayPlaceOn(level.getBlockState(blockpos3.below()), (BlockGetter)level, blockpos3.below()) && level.getBlockState(blockpos3).canBeReplaced(p_49479_) && level.getWorldBorder().isWithinBounds(blockpos3) ? (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)direction) : null;
    }

    public void setPlacedBy(Level p_49499_, BlockPos p_49500_, BlockState p_49501_, @Nullable LivingEntity p_49502_, ItemStack p_49503_) {
        super.setPlacedBy(p_49499_, p_49500_, p_49501_, p_49502_, p_49503_);
        if (!p_49499_.isClientSide()) {
            BlockPos blockpos = p_49500_.relative((Direction)p_49501_.getValue(FACING));
            BlockPos blockpos1 = blockpos.relative(((Direction)p_49501_.getValue(FACING)).getClockWise());
            BlockPos blockpos2 = p_49500_.relative(((Direction)p_49501_.getValue(FACING)).getClockWise());
            p_49499_.setBlock(blockpos, (BlockState)p_49501_.setValue(QUARTER, (Comparable)((Object)QuarterProperty.NORTH_WEST)), 26);
            p_49499_.setBlock(blockpos1, (BlockState)p_49501_.setValue(QUARTER, (Comparable)((Object)QuarterProperty.NORTH_EAST)), 26);
            p_49499_.setBlock(blockpos2, (BlockState)p_49501_.setValue(QUARTER, (Comparable)((Object)QuarterProperty.SOUTH_EAST)), 26);
            p_49499_.updateNeighborsAt(p_49500_, Blocks.AIR);
            p_49499_.updateNeighborsAt(blockpos, Blocks.AIR);
            p_49499_.updateNeighborsAt(blockpos1, Blocks.AIR);
            p_49499_.updateNeighborsAt(blockpos2, Blocks.AIR);
            p_49501_.updateNeighbourShapes((LevelAccessor)p_49499_, p_49500_, 26);
            p_49501_.updateNeighbourShapes((LevelAccessor)p_49499_, blockpos, 26);
            p_49501_.updateNeighbourShapes((LevelAccessor)p_49499_, blockpos1, 26);
            p_49501_.updateNeighbourShapes((LevelAccessor)p_49499_, blockpos2, 26);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean b) {
        if (level instanceof ServerLevel && entity instanceof Boat) {
            level.destroyBlock(new BlockPos((Vec3i)pos), true, entity);
        }
    }

    public BlockState playerWillDestroy(Level p_52878_, BlockPos p_52879_, BlockState p_52880_, Player p_52881_) {
        if (!p_52878_.isClientSide()) {
            if (p_52881_.preventsBlockDrops()) {
                return super.playerWillDestroy(p_52878_, p_52879_, p_52880_, p_52881_);
            }
            HugeLilyPadBlock.dropResources((BlockState)p_52880_, (Level)p_52878_, (BlockPos)p_52879_, null, (Entity)p_52881_, (ItemStack)p_52881_.getMainHandItem());
        }
        return super.playerWillDestroy(p_52878_, p_52879_, p_52880_, p_52881_);
    }

    public void playerDestroy(Level p_52865_, Player p_52866_, BlockPos p_52867_, BlockState p_52868_, @Nullable BlockEntity p_52869_, ItemStack p_52870_) {
        super.playerDestroy(p_52865_, p_52866_, p_52867_, Blocks.AIR.defaultBlockState(), p_52869_, p_52870_);
    }

    public boolean canSurvive(BlockState p_51028_, LevelReader p_51029_, BlockPos p_51030_) {
        BlockPos blockpos = p_51030_.below();
        return this.mayPlaceOn(p_51029_.getBlockState(blockpos), (BlockGetter)p_51029_, blockpos);
    }

    protected boolean mayPlaceOn(BlockState p_58174_, BlockGetter p_58175_, BlockPos p_58176_) {
        FluidState fluidstate = p_58175_.getFluidState(p_58176_);
        FluidState fluidstate1 = p_58175_.getFluidState(p_58176_.above());
        return (fluidstate.getType() == Fluids.WATER || p_58174_.getBlock() instanceof IceBlock) && fluidstate1.getType() == Fluids.EMPTY;
    }

    public BlockState rotate(BlockState p_54125_, Rotation p_54126_) {
        return (BlockState)p_54125_.setValue(FACING, (Comparable)p_54126_.rotate((Direction)p_54125_.getValue(FACING)));
    }

    public BlockState mirror(BlockState p_54122_, Mirror p_54123_) {
        return p_54122_.rotate(p_54123_.getRotation((Direction)p_54122_.getValue(FACING)));
    }
}

