/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.init.ModParticles;
import biomesoplenty.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PusBubbleBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);

    public PusBubbleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState groundState = worldIn.getBlockState(pos.below());
        return groundState.is(ModTags.Blocks.FLESH_DECORATION_PLACEABLE) && groundState.isFaceSturdy((BlockGetter)worldIn, pos.below(), Direction.UP);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    public void onProjectileHit(Level p_57381_, BlockState p_57382_, BlockHitResult p_57383_, Projectile p_57384_) {
        p_57381_.destroyBlock(p_57383_.getBlockPos(), false);
        PusBubbleBlock.spawnParticles(p_57381_, p_57383_.getBlockPos());
    }

    public void attack(BlockState p_55467_, Level p_55468_, BlockPos p_55469_, Player p_55470_) {
        PusBubbleBlock.spawnParticles(p_55468_, p_55469_);
        super.attack(p_55467_, p_55468_, p_55469_, p_55470_);
    }

    public void wasExploded(ServerLevel p_54184_, BlockPos p_54185_, Explosion p_54186_) {
        if (p_54184_ instanceof ServerLevel) {
            PusBubbleBlock.spawnParticles((Level)p_54184_, p_54185_);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean b) {
        if (entity instanceof LivingEntity) {
            level.destroyBlock(pos, false);
            PusBubbleBlock.spawnParticles(level, pos);
        }
    }

    public static void spawnParticles(Level p_55480_, BlockPos pos) {
        RandomSource rand = p_55480_.random;
        for (int i = 0; i < 10; ++i) {
            p_55480_.addParticle((ParticleOptions)ModParticles.PUS, (double)pos.getX() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 8.0, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 8.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean canBeReplaced(BlockState p_53910_, BlockPlaceContext p_53911_) {
        return true;
    }
}

