/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.sound.BOPSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.spider.CaveSpider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpiderEggBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);

    public SpiderEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState groundState = worldIn.getBlockState(pos.below());
        return groundState.isFaceSturdy((BlockGetter)worldIn, pos.below(), Direction.UP);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    public void onProjectileHit(Level p_57381_, BlockState p_57382_, BlockHitResult p_57383_, Projectile p_57384_) {
        p_57381_.playSound((Entity)((Player)null), p_57383_.getBlockPos(), BOPSounds.SPIDER_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + p_57381_.random.nextFloat() * 0.2f);
        p_57381_.destroyBlock(p_57383_.getBlockPos(), false);
        this.spawnSpider(p_57381_, p_57383_.getBlockPos());
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, double p_396999_) {
        level.playSound((Entity)((Player)null), pos, BOPSounds.SPIDER_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + level.random.nextFloat() * 0.2f);
        level.destroyBlock(pos, false);
        this.spawnSpider(level, pos);
    }

    public void spawnAfterBreak(BlockState p_54188_, ServerLevel level, BlockPos p_54190_, ItemStack p_54191_, boolean p_222953_) {
        super.spawnAfterBreak(p_54188_, level, p_54190_, p_54191_, p_222953_);
        Registry registrylookup = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        if (((Boolean)level.getGameRules().get(GameRules.BLOCK_DROPS)).booleanValue() && EnchantmentHelper.getItemEnchantmentLevel((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), (ItemStack)p_54191_) == 0) {
            this.spawnSpider((Level)level, p_54190_);
        }
    }

    public void wasExploded(ServerLevel p_54184_, BlockPos p_54185_, Explosion p_54186_) {
        if (p_54184_ instanceof ServerLevel) {
            this.spawnSpider((Level)p_54184_, p_54185_);
        }
    }

    public void spawnSpider(Level p_154567_, BlockPos p_154569_) {
        CaveSpider spider = (CaveSpider)EntityType.CAVE_SPIDER.create(p_154567_, EntitySpawnReason.TRIGGERED);
        spider.snapTo((double)p_154569_.getX() + 0.5, (double)p_154569_.getY(), (double)p_154569_.getZ() + 0.5, 0.0f, 0.0f);
        p_154567_.addFreshEntity((Entity)spider);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType computationType) {
        return false;
    }
}

