/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.renderer;

import biomesoplenty.block.AnomalyBlock;
import biomesoplenty.block.entity.AnomalyBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class AnomalyRenderer
implements BlockEntityRenderer<AnomalyBlockEntity, AnomalyRenderState> {
    private final BlockRenderDispatcher dispatcher;

    public AnomalyRenderer(BlockEntityRendererProvider.Context context) {
        this.dispatcher = context.blockRenderDispatcher();
    }

    public AnomalyRenderState createRenderState() {
        return new AnomalyRenderState();
    }

    public void extractRenderState(AnomalyBlockEntity blockEntity, AnomalyRenderState renderState, float $$2, Vec3 $$3, @Nullable ModelFeatureRenderer.CrumblingOverlay $$4) {
        BlockEntityRenderState.extractBase((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, (ModelFeatureRenderer.CrumblingOverlay)$$4);
        renderState.anomalyState = blockEntity.getRenderState();
    }

    public void submit(AnomalyRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        BlockState state = renderState.blockState;
        if (state.getValue(AnomalyBlock.ANOMALY_TYPE) == AnomalyBlock.AnomalyType.STABLE) {
            return;
        }
        try {
            submitNodeCollector.submitBlock(poseStack, renderState.anomalyState, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getViewDistance() {
        return 32;
    }

    public static class AnomalyRenderState
    extends BlockEntityRenderState {
        BlockState anomalyState = Blocks.AIR.defaultBlockState();
    }
}

