/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.config.GameplayConfig;
import biomesoplenty.config.GenerationConfig;
import biomesoplenty.core.BiomesOPlenty;
import biomesoplenty.util.config.JsonUtil;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import glitchcore.util.Environment;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class ModConfig {
    private static final String BIOME_CONFIG_FILE_NAME = "biome_toggles.json";
    private static Map<String, Boolean> biomeToggles;
    private static final TreeMap<String, Boolean> defaultBiomeToggles;
    public static GenerationConfig generation;
    public static GameplayConfig gameplay;

    public static void setup() {
        ModConfig.createConfigDirectoryIfNecessary();
    }

    public static boolean isBiomeEnabled(ResourceKey<Biome> key) {
        if (key == null || !key.identifier().getNamespace().equals("biomesoplenty")) {
            return false;
        }
        String optionName = ModConfig.getBiomeConfigOptionName(key);
        Map<String, Boolean> biomeToggles = ModConfig.getBiomeToggles();
        if (!biomeToggles.containsKey(optionName)) {
            ModConfig.addBiomeToggle(key);
        }
        return biomeToggles.get(optionName);
    }

    private static Map<String, Boolean> getBiomeToggles() {
        if (biomeToggles == null) {
            ModConfig.createConfigDirectoryIfNecessary();
            biomeToggles = JsonUtil.getOrCreateConfigFile(ModConfig.getBOPConfigPath().toFile(), BIOME_CONFIG_FILE_NAME, defaultBiomeToggles, new TypeToken<TreeMap<String, Boolean>>(){}.getType());
        }
        return biomeToggles;
    }

    private static String getBiomeConfigOptionName(ResourceKey<Biome> key) {
        return key.identifier().getPath() + "_enabled";
    }

    private static void addBiomeToggle(ResourceKey<Biome> key) {
        ModConfig.getBiomeToggles().put(ModConfig.getBiomeConfigOptionName(key), true);
        ModConfig.updateConfigFile();
    }

    private static void updateConfigFile() {
        JsonUtil.writeFile(ModConfig.getBOPConfigFile(), ModConfig.getBiomeToggles());
    }

    private static void createConfigDirectoryIfNecessary() {
        try {
            Files.createDirectory(ModConfig.getBOPConfigPath(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            BiomesOPlenty.LOGGER.error("Failed to create biomesoplenty config directory", (Throwable)e);
        }
    }

    private static Path getBOPConfigPath() {
        return Environment.getConfigPath().resolve("biomesoplenty/");
    }

    private static File getBOPConfigFile() {
        return new File(ModConfig.getBOPConfigPath().toFile(), BIOME_CONFIG_FILE_NAME);
    }

    static {
        defaultBiomeToggles = Maps.newTreeMap();
        generation = new GenerationConfig();
        gameplay = new GameplayConfig();
        defaultBiomeToggles.putAll(BOPBiomes.getAllBiomes().stream().collect(Collectors.toMap(ModConfig::getBiomeConfigOptionName, key -> true)));
    }
}

