/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.SimpleBlockPredicate;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class NetherVinesFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.getBlockState(pos).getBlock() == Blocks.NETHERRACK;
    protected SimpleBlockPredicate replace = (world, pos) -> NetherVinesFeature.isAir((LevelSimulatedReader)world, pos);
    int minHeight = 8;
    int maxHeight = 20;

    public NetherVinesFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos startPos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        while (startPos.getY() >= world.getMinY() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.below();
        }
        if (!this.placeOn.matches(world, startPos.offset(2, 0, 2))) {
            return false;
        }
        for (int i = 0; i < 128; ++i) {
            BlockPos genPos = startPos.offset(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(3) - rand.nextInt(3), rand.nextInt(4) - rand.nextInt(4));
            if (!this.replace.matches(world, genPos) || !this.placeOn.matches(world, genPos.above())) continue;
            BlockState vineState = BOPBlocks.WILLOW_VINE.defaultBlockState();
            ArrayList validDirections = Lists.newArrayList();
            for (Direction facing : Direction.values()) {
                if (facing == Direction.UP || facing == Direction.DOWN || !this.placeOn.matches(world, genPos.relative(facing))) continue;
                validDirections.add(facing);
            }
            if (validDirections.isEmpty()) continue;
            Direction direction = (Direction)validDirections.get(rand.nextInt(validDirections.size()));
            vineState = (BlockState)vineState.setValue((Property)VineBlock.getPropertyForFace((Direction)direction), (Comparable)Boolean.valueOf(true));
            int targetHeight = this.minHeight + rand.nextInt(this.maxHeight);
            for (int height = 0; height <= targetHeight; ++height) {
                BlockPos offsetPos = genPos.below(height);
                if (!this.replace.matches(world, offsetPos) || !vineState.canSurvive((LevelReader)world, offsetPos)) {
                    return false;
                }
                world.setBlock(offsetPos, vineState, 2);
            }
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.setBlock((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public static boolean isAir(LevelSimulatedReader level, BlockPos pos) {
        return level.isStateAtPosition(pos, BlockBehaviour.BlockStateBase::isAir);
    }
}

