/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.BayouTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BayouTreeFeature
extends BOPTreeFeature<BayouTreeConfiguration> {
    public BayouTreeFeature(Codec<BayouTreeConfiguration> codec) {
        super(codec);
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int baseHeight, int height, BayouTreeConfiguration config) {
        for (int y = 0; y <= height; ++y) {
            int radius = config.trunkWidth - 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.offset(x, y, z);
                    if (pos1.getY() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        BlockPos pos2 = pos.offset(0, height - 2, 0);
        return BayouTreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos2);
    }

    public void generateLeafLayer(LevelAccessor world, RandomSource rand, BlockPos pos, int leavesRadius, FoliagePlacer.FoliageSetter leaves, BayouTreeConfiguration config) {
        int start = -leavesRadius;
        int end = leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || leavesRadius > 0 && (x == start || x == end || z == start || z == end) && rand.nextDouble() < 0.2) continue;
                this.placeLeaves(world, pos.offset(x, 0, z), leaves, config);
            }
        }
    }

    public void generateBranch(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, int length, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, BayouTreeConfiguration config) {
        Direction.Axis axis = direction.getAxis();
        Direction sideways = direction.getClockWise();
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.relative(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.nextInt(2) != 0) continue;
                this.placeLeaves(world, pos1.relative(sideways, j), leaves, config);
            }
            if (length - i <= 2) continue;
            this.placeLeaves(world, pos1.above(), leaves, config);
            this.placeLeaves(world, pos1.above().relative(sideways, -1), leaves, config);
            this.placeLeaves(world, pos1.above().relative(sideways, 1), leaves, config);
            this.placeLog(world, pos1, axis, logs, config);
        }
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        int leavesHeight;
        BayouTreeConfiguration config = (BayouTreeConfiguration)configBase;
        while (startPos.getY() >= world.getMinY() + 1 && this.canReplace((LevelAccessor)world, startPos) || world.getBlockState(startPos).is(BlockTags.LEAVES)) {
            startPos = startPos.below();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        int baseHeight = GeneratorUtil.nextIntBetween(random, (int)((float)height * 0.6f), (int)((float)height * 0.4f));
        int baseLeavesHeight = leavesHeight = height - baseHeight;
        if (leavesHeight < 3) {
            return false;
        }
        leavesHeight = Mth.clamp((int)leavesHeight, (int)3, (int)5);
        leavesHeight = Mth.clamp((int)(leavesHeight + random.nextInt(3)), (int)0, (int)baseLeavesHeight);
        if (!this.checkSpace((LevelAccessor)world, startPos.above(), baseHeight, height, config)) {
            return false;
        }
        BlockPos pos = startPos.above(height);
        this.placeLeaves((LevelAccessor)world, pos, leaves, config);
        pos.below();
        for (int i = 0; i < leavesHeight; ++i) {
            int radius = 3;
            if (i == 0) {
                radius = 1;
            } else if (i <= 2) {
                radius = 2;
            }
            this.generateLeafLayer((LevelAccessor)world, random, pos, radius, leaves, config);
            pos = pos.below();
        }
        this.placeSpanishMoss((LevelAccessor)world, random, pos);
        int trunkRadius = config.trunkWidth - 1;
        for (int x = -trunkRadius; x <= trunkRadius; ++x) {
            for (int z = -trunkRadius; z <= trunkRadius; ++z) {
                int dist = Math.abs(x) + Math.abs(z);
                if (dist > trunkRadius) continue;
                int heightHere = height - 1;
                if (dist == 1) {
                    heightHere = (int)((double)height * (0.2 + random.nextDouble() * 0.15));
                }
                heightHere += random.nextInt(2);
                for (int y = 0; y < heightHere; ++y) {
                    BlockPos local = startPos.offset(x, y, z);
                    boolean air = world.getBlockState(local).getFluidState().isEmpty();
                    this.placeLog((LevelAccessor)world, local, logs, config);
                    if (x != 0 || z != 0 || !air || y >= heightHere - leavesHeight + 1) continue;
                    if (y >= baseHeight && random.nextInt(3) == 0) {
                        double theta = Math.PI * random.nextDouble() * 2.0;
                        int length = 2 + random.nextInt(3);
                        BlockPos branchPos = null;
                        for (int i = 0; i < length; ++i) {
                            branchPos = local.offset(Mth.floor((double)(Math.cos(theta) * (double)i)), i / 2, Mth.floor((double)(Math.sin(theta) * (double)i)));
                            this.placeLog((LevelAccessor)world, branchPos, logs, config);
                        }
                        this.generateLeafLayer((LevelAccessor)world, random, branchPos, 2, leaves, config);
                        this.generateLeafLayer((LevelAccessor)world, random, branchPos.above(), 1, leaves, config);
                        if (random.nextBoolean()) {
                            this.generateLeafLayer((LevelAccessor)world, random, branchPos.above(2), 0, leaves, config);
                        }
                        this.placeSpanishMoss((LevelAccessor)world, random, branchPos);
                        continue;
                    }
                    if (y < baseHeight || random.nextInt(3) != 0) continue;
                    Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                    BlockPos offset = local.relative(direction);
                    this.placeLog((LevelAccessor)world, offset, logs, config);
                    for (Direction dir : Direction.values()) {
                        if (!(random.nextDouble() > 0.2)) continue;
                        this.placeLeaves((LevelAccessor)world, offset.relative(dir), leaves, config);
                    }
                    this.placeSpanishMoss((LevelAccessor)world, random, offset);
                }
            }
        }
        return true;
    }

    private void placeSpanishMoss(LevelAccessor p_236429_1_, RandomSource p_236429_2_, BlockPos p_236429_3_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 75; ++i) {
            BlockState blockstate;
            blockpos$mutable.setWithOffset((Vec3i)p_236429_3_, p_236429_2_.nextInt(5) - p_236429_2_.nextInt(5), p_236429_2_.nextInt(3) - p_236429_2_.nextInt(3), p_236429_2_.nextInt(5) - p_236429_2_.nextInt(5));
            if (!p_236429_1_.isEmptyBlock((BlockPos)blockpos$mutable) || (blockstate = p_236429_1_.getBlockState(blockpos$mutable.above())).getBlock() != BOPBlocks.WILLOW_LEAVES) continue;
            int j = Mth.nextInt((RandomSource)p_236429_2_, (int)1, (int)3);
            if (p_236429_2_.nextInt(5) == 0) {
                j = 1;
            }
            BayouTreeFeature.placeSpanishMossColumn(p_236429_1_, p_236429_2_, blockpos$mutable, j, 17, 25);
        }
    }

    public static void placeSpanishMossColumn(LevelAccessor p_236427_0_, RandomSource p_236427_1_, BlockPos.MutableBlockPos p_236427_2_, int p_236427_3_, int p_236427_4_, int p_236427_5_) {
        for (int i = 0; i <= p_236427_3_; ++i) {
            if (p_236427_0_.isEmptyBlock((BlockPos)p_236427_2_)) {
                if (i == p_236427_3_ || !p_236427_0_.isEmptyBlock(p_236427_2_.below())) {
                    p_236427_0_.setBlock((BlockPos)p_236427_2_, (BlockState)BOPBlocks.SPANISH_MOSS.defaultBlockState().setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)p_236427_1_, (int)p_236427_4_, (int)p_236427_5_))), 2);
                    break;
                }
                p_236427_0_.setBlock((BlockPos)p_236427_2_, BOPBlocks.SPANISH_MOSS_PLANT.defaultBlockState(), 2);
            }
            p_236427_2_.move(Direction.DOWN);
        }
    }

    @Override
    public boolean placeLeaves(LevelAccessor level, BlockPos pos, FoliagePlacer.FoliageSetter leaves, BayouTreeConfiguration config) {
        if (BayouTreeFeature.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)pos)) {
            leaves.set(pos, config.foliageProvider.getState(level.getRandom(), pos));
            return true;
        }
        if (level.getBlockState(pos).getFluidState().is((Fluid)Fluids.WATER)) {
            leaves.set(pos, (BlockState)config.foliageProvider.getState(level.getRandom(), pos).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isWaterAt(pos))));
            return true;
        }
        return false;
    }

    @Override
    protected boolean canReplace(LevelAccessor level, BlockPos pos) {
        return super.canReplace(level, pos) || level.isStateAtPosition(pos, state -> state.liquid());
    }
}

